/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.str2nbt.unsafe.hexal;

import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.parsers.IPlayerBinder;
import io.yukkuric.hexparse.parsers.PluginIotaFactory;
import io.yukkuric.hexparse.parsers.str2nbt.BaseConstParser;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ram.talia.hexal.api.config.HexalConfig;

public class ToGate
extends BaseConstParser.Regex
implements IPlayerBinder {
    public static ToGate INSTANCE = new ToGate();
    class_3222 self;
    int orderId;
    Map<class_1297, Map<class_243, Integer>> usedGates = new HashMap<class_1297, Map<class_243, Integer>>();
    boolean costPardonedThisTurn = false;

    private ToGate() {
        super("^gate(_?)");
    }

    int getGateOrder(class_1297 target, class_243 pos) {
        if (target != null && pos == null) {
            pos = class_243.field_1353;
        }
        if (!this.usedGates.containsKey(target)) {
            this.usedGates.put(target, new HashMap());
        }
        Map<class_243, Integer> innerMap = this.usedGates.get(target);
        this.costPardonedThisTurn = innerMap.containsKey(pos);
        if (!this.costPardonedThisTurn) {
            innerMap.put(pos, this.orderId--);
        }
        return innerMap.get(pos);
    }

    @Override
    public int getCost() {
        int res = super.getCost();
        if (!this.costPardonedThisTurn) {
            res += (int)HexalConfig.getServer().getMakeGateCost();
        }
        return res;
    }

    @Override
    public void BindPlayer(class_3222 p) {
        this.self = p;
        this.orderId = -1;
        this.usedGates.clear();
    }

    @Override
    public class_2487 parse(String node) {
        if (node.length() <= 5) {
            return PluginIotaFactory.makeGate(this.getGateOrder(null, null), null, null);
        }
        String[] frags = node.substring(5).split("_");
        double[] vecRaw = new double[]{0.0, 0.0, 0.0};
        int ptr = 0;
        class_3222 entity = null;
        for (String f : frags) {
            try {
                double tmp = Double.parseDouble(f);
                if (ptr >= 3) continue;
                int n = ptr;
                ptr = (byte)(ptr + 1);
                vecRaw[n] = tmp;
            }
            catch (NumberFormatException tmp) {
                String ff = f.toLowerCase();
                if (ff.equals("self") || ff.equals("myself")) {
                    entity = this.self;
                    continue;
                }
                try {
                    UUID uuid = UUID.fromString(f);
                    entity = ((class_3218)this.self.method_37908()).method_14190(uuid);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(HexParse.doTranslate("hexparse.msg.error.unknown_symbol", f));
                }
            }
        }
        class_243 pos = null;
        if (ptr > 0) {
            pos = new class_243(vecRaw[0], vecRaw[1], vecRaw[2]);
        }
        if (entity != null && pos != null) {
            double maxDist = HexalConfig.getServer().getMaxGateOffset();
            if (pos.method_1033() > maxDist) {
                String expected = HexParse.doTranslate("hexcasting.mishap.invalid_value.gate.offset", maxDist);
                throw new IllegalArgumentException(HexParse.doTranslate("hexcasting.mishap.invalid_value", "", expected, 0, pos));
            }
        }
        return PluginIotaFactory.makeGate(this.getGateOrder((class_1297)entity, pos), pos, entity);
    }
}

