/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.misc;

import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.items.storage.ItemThoughtKnot;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.GreatPatternUnlocker;
import io.yukkuric.hexparse.hooks.PatternMapper;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class CodeHelpers {
    static WeakReference<MinecraftServer> refreshedWorld = new WeakReference<Object>(null);
    static boolean refreshedLocal = false;

    public static void doExtractMedia(class_3222 caster, long amount) {
        CastingVM harness = IXplatAbstractions.INSTANCE.getStaffcastVM(caster, class_1268.field_5808);
        harness.getEnv().extractMedia(amount, false);
    }

    public static IOMethod getItemIO(class_3222 player) {
        if (player == null) {
            return null;
        }
        IOMethod ret = IOMethod.get(player.method_6047());
        if (ret == null) {
            ret = IOMethod.get(player.method_6079());
        }
        return ret;
    }

    public static void doParse(class_3222 player, String code, String rename) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return;
        }
        class_2487 nbt = ParserMain.ParseCode(code, player);
        target.write(nbt);
        if (rename != null) {
            target.rename(rename);
        }
    }

    public static void doParse(class_3222 player, List<String> code, String rename) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return;
        }
        class_2487 nbt = ParserMain.ParseCode(code, player);
        target.write(nbt);
        if (rename != null) {
            target.rename(rename);
        }
    }

    public static String readHand(class_3222 player) {
        return CodeHelpers.readHand(player, StringProcessors.READ_DEFAULT);
    }

    public static String readHand(class_3222 player, StringProcessors.F post) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return null;
        }
        class_2487 iotaRoot = target.read();
        if (iotaRoot == null) {
            return null;
        }
        CodeHelpers.autoRefresh(player.method_5682());
        return ParserMain.ParseIotaNbt(iotaRoot, player, post);
    }

    public static void autoRefresh(MinecraftServer server) {
        if (!refreshedWorld.refersTo(server)) {
            class_3218 level = server.method_30002();
            HexParse.LOGGER.info("auto refresh for server: {}, level: {}", (Object)server.method_16898(), (Object)level);
            PatternMapper.init(level);
            refreshedLocal = true;
            refreshedWorld = new WeakReference<MinecraftServer>(server);
        }
    }

    public static void autoRefreshLocal() {
        if (refreshedLocal) {
            return;
        }
        PatternMapper.initLocal();
        refreshedLocal = true;
    }

    public static void displayCode(class_3222 player, String code) {
        if (player == null || code == null) {
            return;
        }
        class_5250 display = class_2561.method_43469((String)"hexparse.cmd.read.display", (Object[])new Object[]{class_2561.method_43470((String)code).method_27692(class_124.field_1068)}).method_27692(class_124.field_1060);
        player.method_43496((class_2561)CodeHelpers.wrapClickCopy(display, code));
    }

    public static class_5250 wrapClickCopy(class_5250 component, String code) {
        return component.method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, code)).method_10949(class_2568.class_5247.field_24342.method_27671((class_2561)class_2561.method_43471((String)"chat.copy.click"))));
    }

    public static class_5250 wrapClickSuggest(class_5250 component, String command) {
        return component.method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11745, command)).method_10949(class_2568.class_5247.field_24342.method_27671((class_2561)class_2561.method_43470((String)command))));
    }

    public static class_2561 getPatternDisplay(class_2960 id, class_3218 level) {
        String longName = id.toString();
        if (PatternMapper.mapPatternWorld.containsKey(longName) && !GreatPatternUnlocker.get(level).isUnlocked(longName)) {
            return class_2561.method_43470((String)"???");
        }
        class_2487 rawIota = null;
        for (Map<String, class_2487> map : PatternMapper.ShortNameTracker.modifyTargets) {
            if (!map.containsKey(longName)) continue;
            rawIota = map.get(longName);
            break;
        }
        if (rawIota == null) {
            return class_2561.method_43470((String)"NULL");
        }
        return IotaType.getDisplay(rawIota);
    }

    public static class_2561 dumpError(class_5250 raw, Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String trace = sw.toString();
        return raw.method_27696(class_2583.field_24360.method_10977(class_124.field_1079).method_10958(new class_2558(class_2558.class_2559.field_21462, trace)).method_10949(class_2568.class_5247.field_24342.method_27671((class_2561)class_2561.method_43470((String)trace))));
    }

    public static class IOMethod {
        private final BiConsumer<class_1799, class_2487> writer;
        private final Function<class_1799, class_2487> reader;
        private class_1799 current;
        private static Map<Class<? extends IotaHolderItem>, IOMethod> ITEM_IO_TYPES = new HashMap<Class<? extends IotaHolderItem>, IOMethod>();

        public IOMethod(Class<? extends IotaHolderItem> cls, BiConsumer<class_1799, class_2487> writer, Function<class_1799, class_2487> reader) {
            this.reader = reader;
            this.writer = writer;
            ITEM_IO_TYPES.put(cls, this);
        }

        public void write(class_2487 nbt) {
            this.writer.accept(this.current, nbt);
        }

        public class_2487 read() {
            if (this.reader == null) {
                return ((IotaHolderItem)this.current.method_7909()).readIotaTag(this.current);
            }
            return this.reader.apply(this.current);
        }

        public void bind(class_1799 stack) {
            this.current = stack;
        }

        public void rename(String newName) {
            this.current.method_7977((class_2561)class_2561.method_43470((String)newName));
        }

        public Iota readIota(class_3218 world) {
            return ((IotaHolderItem)this.current.method_7909()).readIota(this.current, world);
        }

        static IOMethod get(class_1799 stack) {
            if (stack == null) {
                return null;
            }
            IOMethod ret = ITEM_IO_TYPES.get(stack.method_7909().getClass());
            if (ret != null) {
                ret.bind(stack);
            }
            return ret;
        }

        static {
            BiConsumer<class_1799, class_2487> simpleWrite = (target, nbt) -> target.method_7948().method_10566("data", (class_2520)nbt);
            new IOMethod(ItemFocus.class, simpleWrite, null);
            new IOMethod(ItemThoughtKnot.class, simpleWrite, null);
            new IOMethod(ItemSpellbook.class, (stack, nbt) -> {
                int idx = ItemSpellbook.getPage((class_1799)stack, (int)1);
                String pageKey = String.valueOf(idx);
                NBTHelper.getOrCreateCompound((class_1799)stack, (String)ItemSpellbook.TAG_PAGES).method_10566(pageKey, (class_2520)nbt);
            }, null);
        }
    }
}

