/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.network;

import at.petrak.hexcasting.common.msgs.IMessage;
import io.netty.buffer.ByteBuf;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgHelpers;
import io.yukkuric.hexparse.network.MsgPushClipboard;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public record MsgPullClipboard(String rename, ClipboardMsgMode mode) implements IMessage
{
    public static final class_2960 ID = new class_2960("hexparse", "clipboard/pull");
    static Pattern ANGLES = Pattern.compile("(?<=\")[wedsaq]*(?=\")");
    static int MAX_LENGTH = 102400;

    public void serialize(class_2540 buf) {
        buf.writeByte(this.mode.ordinal());
        MsgHelpers.putString(buf, this.rename);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public static MsgPullClipboard deserialize(ByteBuf buffer) {
        ClipboardMsgMode mode;
        class_2540 buf = new class_2540(buffer);
        try {
            mode = ClipboardMsgMode.values()[buf.readByte()];
        }
        catch (Throwable e) {
            mode = ClipboardMsgMode.INVALID;
        }
        String name = MsgHelpers.getString(buf);
        return new MsgPullClipboard(name, mode);
    }

    public static void handle(MsgPullClipboard self) {
        class_310 MC = class_310.method_1551();
        MC.execute(() -> {
            String code = MC.field_1774.method_1460();
            if (code.isBlank()) {
                return;
            }
            if (self.mode == ClipboardMsgMode.ANGLES_ONLY) {
                Stream<String> matched = ANGLES.matcher(code).results().map(x -> "_" + x.group());
                code = String.join((CharSequence)" ", matched.toList());
            }
            if (code.length() > MAX_LENGTH) {
                if (MC.field_1724 != null) {
                    MC.field_1724.method_43496((class_2561)class_2561.method_43469((String)"hexparse.msg.error.code_too_long", (Object[])new Object[]{code.length()}));
                }
                return;
            }
            CodeHelpers.autoRefreshLocal();
            if (self.mode != ClipboardMsgMode.INVALID) {
                MsgHandlers.CLIENT.sendPacketToServer(new MsgPushClipboard(ParserMain.preMatchClipboardClient(code), self.rename, self.mode));
            }
        });
    }
}

