/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers;

import at.petrak.hexcasting.api.casting.math.HexDir;
import io.yukkuric.hexparse.HexParse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class IotaFactory {
    public static final String TYPE_LIST = "hexcasting:list";
    public static final String TYPE_PATTERN = "hexcasting:pattern";
    public static final String TYPE_DOUBLE = "hexcasting:double";
    public static final String TYPE_VECTOR = "hexcasting:vec3";
    public static final String TYPE_ENTITY = "hexcasting:entity";
    public static final String TYPE_BOOLEAN = "hexcasting:boolean";
    public static final String TYPE_NULL = "hexcasting:null";
    public static final String TYPE_GARBAGE = "hexcasting:garbage";
    public static final String GREAT_PLACEHOLDER_PREFIX = "<";
    public static final String GREAT_PLACEHOLDER_POSTFIX = "?>";
    static final Map<Character, Byte> ANGLE_MAP = new HashMap<Character, Byte>(){
        {
            this.put(Character.valueOf('w'), (byte)0);
            this.put(Character.valueOf('e'), (byte)1);
            this.put(Character.valueOf('d'), (byte)2);
            this.put(Character.valueOf('s'), (byte)3);
            this.put(Character.valueOf('a'), (byte)4);
            this.put(Character.valueOf('q'), (byte)5);
        }
    };

    public static class_2487 makeType(String type, class_2520 data) {
        class_2487 res = new class_2487();
        res.method_10582("hexcasting:type", type);
        res.method_10566("hexcasting:data", data);
        return res;
    }

    public static class_2487 makeList(class_2499 data) {
        return IotaFactory.makeType(TYPE_LIST, (class_2520)data);
    }

    public static class_2487 makePattern(String angles, HexDir start) {
        ArrayList<Byte> angleArray = new ArrayList<Byte>();
        for (char chr : angles.toCharArray()) {
            if (!ANGLE_MAP.containsKey(Character.valueOf(chr))) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.illegal_pattern_angle", Character.valueOf(chr), angles));
            }
            angleArray.add(ANGLE_MAP.get(Character.valueOf(chr)));
        }
        class_2487 pattern = new class_2487();
        pattern.method_10567("start_dir", (byte)start.ordinal());
        pattern.method_36110("angles", angleArray);
        return IotaFactory.makeType(TYPE_PATTERN, (class_2520)pattern);
    }

    public static class_2487 makeComment(String comment) {
        return IotaFactory.makeType("hexparse:comment", (class_2520)class_2519.method_23256((String)comment));
    }

    public static boolean isGreatPatternPlaceholder(String node) {
        return node.startsWith(GREAT_PLACEHOLDER_PREFIX) && node.endsWith(GREAT_PLACEHOLDER_POSTFIX);
    }

    public static String makeUnknownGreatPatternText(String id) {
        return GREAT_PLACEHOLDER_PREFIX + id + GREAT_PLACEHOLDER_POSTFIX;
    }

    public static class_2487 makeUnknownGreatPattern(String id) {
        return IotaFactory.makeComment(IotaFactory.makeUnknownGreatPatternText(id));
    }

    public static class_2487 makeTab(int num) {
        return IotaFactory.makeComment("\n" + " ".repeat(num));
    }

    public static class_2487 makeNum(Double num) {
        return IotaFactory.makeType(TYPE_DOUBLE, (class_2520)class_2489.method_23241((double)num));
    }
}

