/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.hooks.PatternMapper;
import io.yukkuric.hexparse.misc.CodeHelpers;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001d\u0010\r\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/yukkuric/hexparse/commands/CommandConflictResolver;", "", "<init>", "()V", "", "init", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "ctx", "", "listAll", "(Lcom/mojang/brigadier/context/CommandContext;)I", "listName", "redirectName", "hexParse-common"})
public final class CommandConflictResolver {
    @NotNull
    public static final CommandConflictResolver INSTANCE = new CommandConflictResolver();

    private CommandConflictResolver() {
    }

    public final void init() {
        LiteralArgumentBuilder subCmd = (LiteralArgumentBuilder)Commands.m_82127_((String)"conflict").requires(CommandConflictResolver::init$lambda$0);
        LiteralArgumentBuilder[] literalArgumentBuilderArray = new LiteralArgumentBuilder[]{subCmd};
        HexParseCommands.registerLine(this::listAll, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
        literalArgumentBuilderArray = new LiteralArgumentBuilder[]{subCmd, Commands.m_82127_((String)"list")};
        HexParseCommands.registerLine(this::listAll, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
        literalArgumentBuilderArray = new ArgumentBuilder[]{subCmd, Commands.m_82127_((String)"list"), Commands.m_82129_((String)"name", (ArgumentType)((ArgumentType)ResourceLocationArgument.m_106984_()))};
        HexParseCommands.registerLine(this::listName, (ArgumentBuilder[])literalArgumentBuilderArray);
        literalArgumentBuilderArray = new ArgumentBuilder[]{subCmd, Commands.m_82127_((String)"set"), Commands.m_82129_((String)"name", (ArgumentType)((ArgumentType)ResourceLocationArgument.m_106984_())), Commands.m_82129_((String)"id", (ArgumentType)((ArgumentType)ResourceLocationArgument.m_106984_()))};
        HexParseCommands.registerLine(this::redirectName, (ArgumentBuilder[])literalArgumentBuilderArray);
    }

    private final int listAll(CommandContext<CommandSourceStack> ctx) {
        CodeHelpers.autoRefresh(((CommandSourceStack)ctx.getSource()).m_81377_());
        Set<String> set = PatternMapper.ShortNameTracker.shortNameWithConflicts;
        Intrinsics.checkNotNullExpressionValue(set, (String)"shortNameWithConflicts");
        List targets = CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)set));
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237115_((String)"hexparse.cmd.conflict.list_all.title"));
        for (String name : targets) {
            Object[] objectArray = new Object[2];
            MutableComponent mutableComponent = Component.m_237113_((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            objectArray[0] = HexUtils.getAqua((MutableComponent)mutableComponent);
            Set<ResourceLocation> set2 = PatternMapper.ShortNameTracker.allPointed.get(name);
            objectArray[1] = set2 != null ? set2.size() : 0;
            MutableComponent msg = Component.m_237110_((String)"hexparse.cmd.conflict.list_all.entry", (Object[])objectArray);
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)CodeHelpers.wrapClickSuggest(msg, "/hexParse conflict list " + name));
        }
        return targets.size();
    }

    private final int listName(CommandContext<CommandSourceStack> ctx) {
        CodeHelpers.autoRefresh(((CommandSourceStack)ctx.getSource()).m_81377_());
        String name = ResourceLocationArgument.m_107011_(ctx, (String)"name").m_135815_();
        ResourceLocation curTarget = PatternMapper.ShortNameTracker.mapActiveShortName.get(name);
        if (curTarget == null) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
            MutableComponent mutableComponent = Component.m_237115_((String)"hexparse.cmd.conflict.error.name");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            commandSourceStack.m_81352_((Component)HexUtils.getDarkRed((MutableComponent)mutableComponent));
            return -1;
        }
        CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
        Object[] objectArray = new Object[2];
        MutableComponent mutableComponent = Component.m_237113_((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        objectArray[0] = HexUtils.getAqua((MutableComponent)mutableComponent);
        MutableComponent mutableComponent2 = Component.m_237113_((String)curTarget.toString());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
        objectArray[1] = HexUtils.getGold((MutableComponent)mutableComponent2);
        commandSourceStack.m_243053_((Component)Component.m_237110_((String)"hexparse.cmd.conflict.list.title", (Object[])objectArray));
        Collection<Object> collection = PatternMapper.ShortNameTracker.allPointed.get(name);
        if (collection == null || (collection = CollectionsKt.sorted((Iterable)collection)) == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection<Object> allEntries = collection;
        for (ResourceLocation resourceLocation : allEntries) {
            Object[] objectArray2 = new Object[2];
            MutableComponent mutableComponent3 = Component.m_237113_((String)resourceLocation.toString());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"literal(...)");
            objectArray2[0] = HexUtils.getGold((MutableComponent)mutableComponent3);
            objectArray2[1] = CodeHelpers.getPatternDisplay(resourceLocation, ((CommandSourceStack)ctx.getSource()).m_81372_());
            MutableComponent msg = Component.m_237110_((String)"hexparse.cmd.conflict.list.entry", (Object[])objectArray2);
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)CodeHelpers.wrapClickSuggest(msg, "/hexParse conflict set " + name + " " + resourceLocation));
        }
        return allEntries.size();
    }

    private final int redirectName(CommandContext<CommandSourceStack> ctx) {
        CodeHelpers.autoRefresh(((CommandSourceStack)ctx.getSource()).m_81377_());
        String name = ResourceLocationArgument.m_107011_(ctx, (String)"name").m_135815_();
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"id");
        PatternMapper.ShortNameTracker.redirectShortName(name, id);
        CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
        Object[] objectArray = new Object[3];
        MutableComponent mutableComponent = Component.m_237113_((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        objectArray[0] = HexUtils.getAqua((MutableComponent)mutableComponent);
        MutableComponent mutableComponent2 = Component.m_237113_((String)id.toString());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
        objectArray[1] = HexUtils.getGold((MutableComponent)mutableComponent2);
        objectArray[2] = CodeHelpers.getPatternDisplay(id, ((CommandSourceStack)ctx.getSource()).m_81372_());
        commandSourceStack.m_243053_((Component)Component.m_237110_((String)"hexparse.cmd.conflict.edited", (Object[])objectArray));
        return 1;
    }

    private static final boolean init$lambda$0(CommandSourceStack s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (HexParse.HELPERS.isPhysicalClient()) {
            return true;
        }
        return s.m_6761_(2);
    }
}

