/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPullClipboard;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001b\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\f\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001b\u0010\r\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\r\u0010\u000bJ\u001d\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/yukkuric/hexparse/commands/CommandMindStackIO;", "", "<init>", "()V", "", "init", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "ctx", "", "pullClipboard", "(Lcom/mojang/brigadier/context/CommandContext;)I", "readStack", "writeStack", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/nbt/CompoundTag;", "iotaTag", "writeStackWithIota", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/nbt/CompoundTag;)V", "hexParse-common"})
public final class CommandMindStackIO {
    @NotNull
    public static final CommandMindStackIO INSTANCE = new CommandMindStackIO();

    private CommandMindStackIO() {
    }

    public final void init() {
        LiteralArgumentBuilder[] literalArgumentBuilderArray = new LiteralArgumentBuilder[]{Commands.m_82127_((String)"mind_stack"), Commands.m_82127_((String)"peek")};
        LiteralArgumentBuilder subCmd = (LiteralArgumentBuilder)HexParseCommands.registerLine(this::readStack, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
        literalArgumentBuilderArray = new ArgumentBuilder[]{subCmd, Commands.m_82127_((String)"push"), Commands.m_82129_((String)"code", (ArgumentType)((ArgumentType)StringArgumentType.string()))};
        HexParseCommands.registerLine(this::writeStack, (ArgumentBuilder[])literalArgumentBuilderArray);
        literalArgumentBuilderArray = new LiteralArgumentBuilder[]{subCmd, Commands.m_82127_((String)"push_clipboard")};
        HexParseCommands.registerLine(this::pullClipboard, (ArgumentBuilder[])((ArgumentBuilder[])literalArgumentBuilderArray));
    }

    public final int readStack(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        CastingImage img = IXplatAbstractions.INSTANCE.getStaffcastVM(player, InteractionHand.MAIN_HAND).getImage();
        List stack = img.getStack();
        Iota lastIota = stack.isEmpty() ? (Iota)new NullIota() : (Iota)stack.get(stack.size() - 1);
        String code = ParserMain.ParseIotaNbt(IotaType.serialize((Iota)lastIota), player, StringProcessors.READ_DEFAULT);
        CodeHelpers.displayCode(player, code);
        return 1;
    }

    public final int writeStack(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        String code = StringArgumentType.getString(ctx, (String)"code");
        CompoundTag nbt = ParserMain.ParseCode(code, ((CommandSourceStack)ctx.getSource()).m_230896_());
        ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).m_230896_();
        Intrinsics.checkNotNull((Object)serverPlayer);
        Intrinsics.checkNotNull((Object)nbt);
        this.writeStackWithIota(serverPlayer, nbt);
        return 1;
    }

    public final int pullClipboard(@NotNull CommandContext<CommandSourceStack> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        MsgHandlers.SERVER.sendPacketToPlayer(((CommandSourceStack)ctx.getSource()).m_230896_(), new MsgPullClipboard(null, ClipboardMsgMode.PUSH_MIND));
        return 1;
    }

    public final void writeStackWithIota(@NotNull ServerPlayer player, @NotNull CompoundTag iotaTag) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)iotaTag, (String)"iotaTag");
        Iota newIota = IotaType.deserialize((CompoundTag)iotaTag, (ServerLevel)player.m_284548_());
        CastingImage img = IXplatAbstractions.INSTANCE.getStaffcastVM(player, InteractionHand.MAIN_HAND).getImage();
        List stack = img.getStack();
        if (!TypeIntrinsics.isMutableList((Object)stack)) {
            stack = new ArrayList(stack);
            img = CastingImage.copy$default((CastingImage)img, (List)stack, (int)0, null, (boolean)false, (long)0L, null, (int)62, null);
        }
        List list = stack;
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<at.petrak.hexcasting.api.casting.iota.Iota>");
        List list2 = TypeIntrinsics.asMutableList((Object)list);
        Intrinsics.checkNotNull((Object)newIota);
        list2.add(newIota);
        IXplatAbstractions.INSTANCE.setStaffcastImage(player, img);
    }
}

