/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.hooks;

import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.yukkuric.hexparse.hooks.CommentIota;
import io.yukkuric.hexparse.parsers.IotaFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public class CommentIotaType
extends IotaType<CommentIota> {
    public static CommentIotaType INSTANCE;
    public static final String TYPE_ID = "hexparse:comment";
    public static final HexPattern COMMENT_PATTERN;
    static final Supplier<Boolean> getShiftKeyDown;
    public static final Action NULL_ACTION;
    static String cachedGreatPatternKeys;

    public CommentIota deserialize(Tag tag, ServerLevel serverLevel) throws IllegalArgumentException {
        return new CommentIota(tag.m_7916_());
    }

    public Component display(Tag tag) {
        String raw = tag.m_7916_();
        if (!IotaFactory.isGreatPatternPlaceholder(raw)) {
            if (getShiftKeyDown.get().booleanValue()) {
                return Component.m_237119_();
            }
            if (!raw.isEmpty() && raw.charAt(0) == '\"') {
                return Component.m_237113_((String)raw.substring(1, raw.length() - 1)).m_130940_(ChatFormatting.DARK_GREEN);
            }
            return Component.m_237113_((String)raw).m_130940_(ChatFormatting.DARK_GREEN);
        }
        int len = raw.length();
        int loopSize = (int)Math.floor((double)len * Math.PI * 2.0);
        long ticker = System.currentTimeMillis() / 20L;
        int looper = (int)(ticker % (long)loopSize);
        if (looper >= len * 2) {
            return Component.m_237113_((String)raw).m_130938_(s -> s.m_178520_(PatternIota.TYPE.color()));
        }
        String filledStr = CommentIotaType.pickRandomGreatPatternKey(ticker -= (long)looper, len - "<".length() - "?>".length());
        filledStr = IotaFactory.makeUnknownGreatPatternText(filledStr);
        if (looper <= len) {
            return Component.m_237113_((String)filledStr.substring(0, looper)).m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)raw.substring(looper)).m_130938_(s -> s.m_178520_(PatternIota.TYPE.color())));
        }
        return Component.m_237113_((String)raw.substring(0, looper -= len)).m_130938_(s -> s.m_178520_(PatternIota.TYPE.color())).m_7220_((Component)Component.m_237113_((String)filledStr.substring(looper)).m_130940_(ChatFormatting.LIGHT_PURPLE));
    }

    public int color() {
        return -16733696;
    }

    public static void registerSelf() {
        CommentIotaType.registerIota();
    }

    public static void registerIota() {
        Registry.m_122961_((Registry)HexIotaTypes.REGISTRY, (String)TYPE_ID, (Object)((Object)INSTANCE));
    }

    static String pickRandomGreatPatternKey(long from, int size) {
        int startIdx;
        int endIdx;
        if (cachedGreatPatternKeys == null) {
            ArrayList<String> randList = new ArrayList<String>();
            Registry registry = IXplatAbstractions.INSTANCE.getActionRegistry();
            for (Map.Entry entry : registry.m_6579_()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                if (!HexUtils.isOfTag((Registry)registry, (ResourceKey)key, (TagKey)HexTags.Actions.PER_WORLD_PATTERN)) continue;
                ResourceLocation regKey = key.m_135782_();
                for (int i = 0; i < 3; ++i) {
                    randList.add(regKey.m_135815_());
                }
            }
            Collections.shuffle(randList);
            StringBuilder sb = new StringBuilder();
            for (Object e : randList) {
                sb.append(e);
                sb.append("---");
            }
            cachedGreatPatternKeys = sb.toString();
        }
        if ((endIdx = (startIdx = (int)(from % (long)cachedGreatPatternKeys.length())) + size) <= cachedGreatPatternKeys.length()) {
            return cachedGreatPatternKeys.substring(startIdx, endIdx);
        }
        return cachedGreatPatternKeys.substring(startIdx) + cachedGreatPatternKeys.substring(0, endIdx - cachedGreatPatternKeys.length());
    }

    static {
        Supplier<Boolean> getter;
        INSTANCE = new CommentIotaType();
        COMMENT_PATTERN = HexPattern.fromAngles((String)"adadaqadadaaww", (HexDir)HexDir.SOUTH_EAST);
        try {
            getter = Screen::m_96638_;
        }
        catch (Throwable e) {
            getter = () -> false;
        }
        getShiftKeyDown = getter;
        NULL_ACTION = new Action(){
            static final List<OperatorSideEffect> NO_EFFECT = new ArrayList<OperatorSideEffect>();

            @NotNull
            public OperationResult operate(CastingEnvironment env, CastingImage img, SpellContinuation cont) {
                return new OperationResult(img, NO_EFFECT, cont, HexEvalSounds.NOTHING);
            }
        };
    }
}

