/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.hooks;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.parsers.IotaFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class PatternMapper {
    public static final Map<String, CompoundTag> mapPatternMeta = new HashMap<String, CompoundTag>();
    public static final Map<String, CompoundTag> mapPattern = new HashMap<String, CompoundTag>();
    public static final Map<String, CompoundTag> mapPatternWorld = new HashMap<String, CompoundTag>();

    static void _setMap(Map<String, CompoundTag> map, ResourceLocation id, String seq, HexDir dir) {
        String idLong = id.toString();
        String idShort = id.m_135815_();
        CompoundTag pattern = IotaFactory.makePattern(seq, dir);
        map.put(idLong, pattern);
        if (ShortNameTracker.recordNewShortName(id)) {
            map.put(idShort, pattern);
        }
    }

    public static void init(ServerLevel level) {
        mapPattern.clear();
        mapPatternWorld.clear();
        ShortNameTracker.clear(level);
        Registry registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        ServerLevel overworld = level.m_7654_().m_129783_();
        DimensionDataStorage ds = overworld.m_8895_();
        ScrungledPatternsSave perWorldPatterns = ScrungledPatternsSave.createFromScratch((long)level.m_7328_());
        ds.m_164855_("hexcasting.per-world-patterns.0.1.0", (SavedData)perWorldPatterns);
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            if (HexUtils.isOfTag((Registry)registry, (ResourceKey)key, (TagKey)HexTags.Actions.PER_WORLD_PATTERN)) {
                Pair perWorldEntry = perWorldPatterns.lookupReverse(key);
                if (perWorldEntry == null) continue;
                PatternMapper._setMap(mapPatternWorld, key.m_135782_(), (String)perWorldEntry.getFirst(), ((ScrungledPatternsSave.PerWorldEntry)perWorldEntry.getSecond()).canonicalStartDir());
                continue;
            }
            HexPattern pattern = ((ActionRegistryEntry)entry.getValue()).prototype();
            PatternMapper._setMap(mapPattern, key.m_135782_(), pattern.anglesSignature(), pattern.getStartDir());
        }
    }

    public static void initLocal() {
        Registry registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Map<String, CompoundTag> mapper = HexUtils.isOfTag((Registry)registry, (ResourceKey)key, (TagKey)HexTags.Actions.PER_WORLD_PATTERN) ? mapPatternWorld : mapPattern;
            PatternMapper._setMap(mapper, key.m_135782_(), "", HexDir.EAST);
        }
    }

    static {
        mapPatternMeta.put("\\", IotaFactory.makePattern("qqqaw", HexDir.WEST));
        mapPatternMeta.put("del", IotaFactory.makePattern("eeedw", HexDir.EAST));
        mapPatternMeta.put("(", IotaFactory.makePattern("qqq", HexDir.WEST));
        mapPatternMeta.put(")", IotaFactory.makePattern("eee", HexDir.EAST));
    }

    public static class ShortNameTracker {
        public static final Map<String, CompoundTag>[] modifyTargets = new Map[]{mapPattern, mapPatternWorld};
        public static final Map<String, Set<ResourceLocation>> allPointed = new HashMap<String, Set<ResourceLocation>>();
        public static final Map<String, ResourceLocation> mapActiveShortName = new HashMap<String, ResourceLocation>();
        public static final Set<String> shortNameWithConflicts = new HashSet<String>();
        private static ShortNameTrackerPersistent manualTargets;

        static boolean recordNewShortName(ResourceLocation id) {
            boolean imBoss;
            String shortName = id.m_135815_();
            String longName = id.toString();
            Set locList = allPointed.computeIfAbsent(shortName, k -> new HashSet());
            locList.add(id);
            if (locList.size() > 1) {
                shortNameWithConflicts.add(shortName);
            }
            ResourceLocation idExist = mapActiveShortName.get(shortName);
            boolean manualSelected = false;
            boolean manualOld = false;
            if (manualTargets != null) {
                String selectedLong = manualTargets.get(shortName);
                manualSelected = longName.equals(selectedLong);
                manualOld = !StringUtil.m_14408_((String)selectedLong);
            }
            boolean bl = imBoss = manualSelected || !manualOld && id.m_135827_().equals("hexcasting");
            if (idExist == null || imBoss) {
                mapActiveShortName.put(shortName, id);
                return true;
            }
            return false;
        }

        static void clear(ServerLevel level) {
            allPointed.clear();
            mapActiveShortName.clear();
            shortNameWithConflicts.clear();
            manualTargets = ShortNameTrackerPersistent.get(level);
        }

        public static String getActiveLongName(String shortName) {
            ResourceLocation id = mapActiveShortName.get(shortName);
            return id == null ? shortName : id.toString();
        }

        public static void redirectShortName(String shortName, ResourceLocation newId) {
            Set<ResourceLocation> validIdSet = allPointed.get(shortName);
            if (validIdSet == null || !shortNameWithConflicts.contains(shortName)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.name", new Object[0])));
            }
            if (!validIdSet.contains(newId)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.id", newId)));
            }
            String longName = newId.toString();
            boolean found = false;
            for (Map<String, CompoundTag> map : modifyTargets) {
                CompoundTag tryLongEntry;
                map.remove(shortName);
                if (found || (tryLongEntry = map.get(longName)) == null) continue;
                found = true;
                map.put(shortName, tryLongEntry);
            }
            if (!found) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, "excuse me WTF?"));
            }
            mapActiveShortName.put(shortName, newId);
            if (manualTargets != null) {
                manualTargets.put(shortName, longName);
            }
        }
    }

    private static class ShortNameTrackerPersistent
    extends SavedData {
        static final String SAVENAME = "hexparse.short_name.settings";
        static final CompoundTag settings = new CompoundTag();

        ShortNameTrackerPersistent() {
        }

        ShortNameTrackerPersistent(CompoundTag load) {
            settings.m_128391_(load);
        }

        static ShortNameTrackerPersistent get(ServerLevel level) {
            DimensionDataStorage ds = level.m_8895_();
            return (ShortNameTrackerPersistent)ds.m_164861_(ShortNameTrackerPersistent::new, ShortNameTrackerPersistent::new, SAVENAME);
        }

        @NotNull
        public CompoundTag m_7176_(CompoundTag body) {
            body.m_128391_(settings);
            return body;
        }

        public String get(String shortName) {
            return settings.m_128461_(shortName);
        }

        public void put(String shortName, String longName) {
            settings.m_128359_(shortName, longName);
        }
    }
}

