/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.mixin.iota;

import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import io.yukkuric.hexparse.config.HexParseConfig;
import io.yukkuric.hexparse.mixin_interface.NestedCounter;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternIota.class})
public class MixinPatternIota {
    private static final List<ChatFormatting> COLORS = List.of(ChatFormatting.AQUA, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GREEN, ChatFormatting.YELLOW, ChatFormatting.BLUE);

    @Inject(method={"display"}, at={@At(value="RETURN")})
    private static void hookParens(HexPattern pat, CallbackInfoReturnable<Component> cir) {
        int cnt;
        if (!HexParseConfig.colorfulNested()) {
            return;
        }
        List angles = pat.getAngles();
        if (angles.size() != 3) {
            return;
        }
        boolean isLeft = true;
        boolean isRight = true;
        for (HexAngle dir : angles) {
            isLeft &= dir == HexAngle.LEFT;
            isRight &= dir == HexAngle.RIGHT;
        }
        if (!isLeft && !isRight) {
            return;
        }
        if (isLeft) {
            NestedCounter.EnterParen();
        }
        if ((cnt = NestedCounter.GetParensCount()) < 0) {
            return;
        }
        MutableComponent comp = (MutableComponent)cir.getReturnValue();
        comp.m_130940_(COLORS.get(cnt % COLORS.size()));
        if (isRight) {
            NestedCounter.LeaveParen();
        }
    }
}

