/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.nbt2str;

import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.castables.SpecialHandler;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.StaffCastEnv;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.casting.actions.math.SpecialHandlerNumberLiteral;
import at.petrak.hexcasting.common.casting.actions.stack.SpecialHandlerMask;
import io.yukkuric.hexparse.parsers.IPlayerBinder;
import io.yukkuric.hexparse.parsers.nbt2str.INbt2Str;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;

public class PatternParser
implements INbt2Str,
IPlayerBinder {
    static Map<String, String> SPECIAL_PATTERNS = new HashMap<String, String>(){
        {
            this.put("qqq", "(");
            this.put("eee", ")");
            this.put("qqqaw", "\\");
        }
    };
    static List<Iota> FOO_LIST = List.of();
    ServerLevel level;
    ServerPlayer player;

    @Override
    public boolean match(CompoundTag node) {
        return this.isType(node, "hexcasting:pattern");
    }

    @Override
    public String parse(CompoundTag node) {
        HexPattern pattern = HexPattern.fromNBT((CompoundTag)node.m_128469_("hexcasting:data"));
        String angleSigs = pattern.anglesSignature();
        if (SPECIAL_PATTERNS.containsKey(angleSigs)) {
            return SPECIAL_PATTERNS.get(angleSigs);
        }
        PatternShapeMatch matcher = PatternRegistryManifest.matchPattern((HexPattern)pattern, (CastingEnvironment)new StaffCastEnv(this.player, InteractionHand.MAIN_HAND), (boolean)false);
        ResourceLocation opId = null;
        if (matcher instanceof PatternShapeMatch.Normal) {
            PatternShapeMatch.Normal nm = (PatternShapeMatch.Normal)matcher;
            opId = nm.key.m_135782_();
        } else if (matcher instanceof PatternShapeMatch.PerWorld) {
            PatternShapeMatch.PerWorld pm = (PatternShapeMatch.PerWorld)matcher;
            opId = pm.key.m_135782_();
        } else if (matcher instanceof PatternShapeMatch.Special) {
            PatternShapeMatch.Special sm = (PatternShapeMatch.Special)matcher;
            SpecialHandler handler = sm.handler;
            if (handler instanceof SpecialHandlerMask) {
                SpecialHandlerMask hm = (SpecialHandlerMask)handler;
                StringBuilder maskBuilder = new StringBuilder("mask_");
                for (Boolean m : hm.getMask()) {
                    maskBuilder.append(m != false ? (char)'-' : 'v');
                }
                return maskBuilder.toString();
            }
            if (handler instanceof SpecialHandlerNumberLiteral) {
                SpecialHandlerNumberLiteral hn = (SpecialHandlerNumberLiteral)handler;
                return "num_" + this.displayMinimal(hn.getX());
            }
        }
        if (opId != null) {
            if (opId.m_135827_().equals("hexcasting")) {
                return opId.m_135815_();
            }
            return opId.toString();
        }
        return "_" + angleSigs;
    }

    @Override
    public void BindPlayer(ServerPlayer p) {
        this.player = p;
        this.level = p.m_284548_();
    }
}

