/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.actions;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.spell.ConstMediaAction;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.SpellList;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.ListIota;
import at.petrak.hexcasting.api.spell.iota.PatternIota;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.spell.mishaps.MishapDisallowedSpell;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidPattern;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.yukkuric.hexparse.hooks.GreatPatternUnlocker;
import io.yukkuric.hexparse.hooks.PatternMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010\u001d\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\u00020\u001f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\"\u0010%\u001a\u00020$8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00062"}, d2={"Lio/yukkuric/hexparse/actions/ActionLearnGreatPatterns;", "Lat/petrak/hexcasting/api/spell/ConstMediaAction;", "<init>", "()V", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "args", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "ctx", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/spell/casting/CastingContext;)Ljava/util/List;", "Lnet/minecraft/world/item/ItemStack;", "item", "extractTargetFromItem", "(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "pattern", "Lnet/minecraft/resources/ResourceLocation;", "fetchPatternGreatKey", "(Lat/petrak/hexcasting/api/spell/math/HexPattern;)Lnet/minecraft/resources/ResourceLocation;", "target", "Ljava/util/ArrayList;", "Lat/petrak/hexcasting/api/spell/iota/PatternIota;", "output", "", "processIota", "(Lat/petrak/hexcasting/api/spell/iota/Iota;Ljava/util/ArrayList;)V", "", "seq", "processIotaList", "(Ljava/lang/Iterable;Ljava/util/ArrayList;)V", "", "argc", "I", "getArgc", "()I", "Lnet/minecraft/server/level/ServerLevel;", "cachedLevel", "Lnet/minecraft/server/level/ServerLevel;", "getCachedLevel", "()Lnet/minecraft/server/level/ServerLevel;", "setCachedLevel", "(Lnet/minecraft/server/level/ServerLevel;)V", "Lio/yukkuric/hexparse/hooks/GreatPatternUnlocker;", "cachedUnlocker", "Lio/yukkuric/hexparse/hooks/GreatPatternUnlocker;", "getCachedUnlocker", "()Lio/yukkuric/hexparse/hooks/GreatPatternUnlocker;", "setCachedUnlocker", "(Lio/yukkuric/hexparse/hooks/GreatPatternUnlocker;)V", "hexParse-common"})
@SourceDebugExtension(value={"SMAP\nActionLearnGreatPatterns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionLearnGreatPatterns.kt\nio/yukkuric/hexparse/actions/ActionLearnGreatPatterns\n+ 2 OperatorUtils.kt\nat/petrak/hexcasting/api/spell/OperatorUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n305#2:86\n2624#3,3:87\n*S KotlinDebug\n*F\n+ 1 ActionLearnGreatPatterns.kt\nio/yukkuric/hexparse/actions/ActionLearnGreatPatterns\n*L\n46#1:86\n70#1:87,3\n*E\n"})
public final class ActionLearnGreatPatterns
implements ConstMediaAction {
    @NotNull
    public static final ActionLearnGreatPatterns INSTANCE = new ActionLearnGreatPatterns();
    private static final int argc;
    public static ServerLevel cachedLevel;
    public static GreatPatternUnlocker cachedUnlocker;

    private ActionLearnGreatPatterns() {
    }

    public int getArgc() {
        return argc;
    }

    @NotNull
    public final ServerLevel getCachedLevel() {
        ServerLevel serverLevel = cachedLevel;
        if (serverLevel != null) {
            return serverLevel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cachedLevel");
        return null;
    }

    public final void setCachedLevel(@NotNull ServerLevel serverLevel) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"<set-?>");
        cachedLevel = serverLevel;
    }

    @NotNull
    public final GreatPatternUnlocker getCachedUnlocker() {
        GreatPatternUnlocker greatPatternUnlocker = cachedUnlocker;
        if (greatPatternUnlocker != null) {
            return greatPatternUnlocker;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cachedUnlocker");
        return null;
    }

    public final void setCachedUnlocker(@NotNull GreatPatternUnlocker greatPatternUnlocker) {
        Intrinsics.checkNotNullParameter((Object)((Object)greatPatternUnlocker), (String)"<set-?>");
        cachedUnlocker = greatPatternUnlocker;
    }

    @NotNull
    public List<Iota> execute(@NotNull List<? extends Iota> args, @NotNull CastingContext ctx) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ServerPlayer player = ctx.getCaster();
        ServerLevel level = ctx.getWorld();
        this.setCachedLevel(level);
        GreatPatternUnlocker greatPatternUnlocker = GreatPatternUnlocker.get(level);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)greatPatternUnlocker), (String)"get(...)");
        this.setCachedUnlocker(greatPatternUnlocker);
        if (player == null) {
            throw new MishapDisallowedSpell(null, 1, null);
        }
        ArrayList<PatternIota> returns = new ArrayList<PatternIota>();
        ItemStack item = player.m_21120_(ctx.getOtherHand());
        List<Iota> targetIotas = null;
        if (!item.m_41619_()) {
            itemStack = item;
            Intrinsics.checkNotNull((Object)itemStack);
            targetIotas = this.extractTargetFromItem(itemStack);
            if (targetIotas != null) {
                this.processIotaList((Iterable<? extends Iota>)targetIotas, returns);
            }
        }
        if (!(item = player.m_21120_(ctx.getCastingHand())).m_41619_()) {
            itemStack = item;
            Intrinsics.checkNotNull((Object)itemStack);
            targetIotas = this.extractTargetFromItem(itemStack);
            if (targetIotas != null) {
                this.processIotaList((Iterable<? extends Iota>)targetIotas, returns);
            }
        }
        List $this$asActionResult$iv = returns;
        boolean $i$f$getAsActionResult = false;
        return CollectionsKt.listOf((Object)new ListIota($this$asActionResult$iv));
    }

    private final List<Iota> extractTargetFromItem(ItemStack item) {
        Iota inner;
        ADIotaHolder holderIota = IXplatAbstractions.INSTANCE.findDataHolder(item);
        if (holderIota != null && (inner = holderIota.readIota(this.getCachedLevel())) != null) {
            return CollectionsKt.listOf((Object)inner);
        }
        ADHexHolder holderHex = IXplatAbstractions.INSTANCE.findHexHolder(item);
        if (holderHex != null) {
            return holderHex.getHex(this.getCachedLevel());
        }
        return null;
    }

    private final void processIotaList(Iterable<? extends Iota> seq, ArrayList<PatternIota> output) {
        for (Iota iota : seq) {
            if (iota instanceof ListIota) {
                SpellList spellList = ((ListIota)iota).getList();
                Intrinsics.checkNotNullExpressionValue((Object)spellList, (String)"getList(...)");
                this.processIotaList((Iterable)spellList, output);
                continue;
            }
            this.processIota(iota, output);
        }
    }

    private final void processIota(Iota target, ArrayList<PatternIota> output) {
        boolean bl;
        ResourceLocation key;
        block6: {
            if (!(target instanceof PatternIota)) {
                return;
            }
            HexPattern hexPattern = ((PatternIota)target).getPattern();
            Intrinsics.checkNotNullExpressionValue((Object)hexPattern, (String)"getPattern(...)");
            ResourceLocation resourceLocation = this.fetchPatternGreatKey(hexPattern);
            if (resourceLocation == null) {
                return;
            }
            key = resourceLocation;
            Iterable $this$none$iv = output;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PatternIota it = (PatternIota)element$iv;
                    boolean bl2 = false;
                    if (!it.toleratesOther(target)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl && this.getCachedUnlocker().unlock(key.toString())) {
            output.add((PatternIota)target);
        }
    }

    private final ResourceLocation fetchPatternGreatKey(HexPattern pattern) {
        try {
            ResourceLocation match = (ResourceLocation)PatternRegistry.matchPatternAndID((HexPattern)pattern, (ServerLevel)this.getCachedLevel()).getSecond();
            if (PatternMapper.greatMapper.containsKey(match)) {
                return match;
            }
            return null;
        }
        catch (MishapInvalidPattern e) {
            return null;
        }
    }

    public boolean getAlwaysProcessGreatSpell() {
        return ConstMediaAction.DefaultImpls.getAlwaysProcessGreatSpell((ConstMediaAction)this);
    }

    public boolean getCausesBlindDiversion() {
        return ConstMediaAction.DefaultImpls.getCausesBlindDiversion((ConstMediaAction)this);
    }

    @NotNull
    public Component getDisplayName() {
        return ConstMediaAction.DefaultImpls.getDisplayName((ConstMediaAction)this);
    }

    public boolean isGreat() {
        return ConstMediaAction.DefaultImpls.isGreat((ConstMediaAction)this);
    }

    public int getMediaCost() {
        return ConstMediaAction.DefaultImpls.getMediaCost((ConstMediaAction)this);
    }

    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        return ConstMediaAction.DefaultImpls.operate((ConstMediaAction)this, (SpellContinuation)continuation, stack, (Iota)ravenmind, (CastingContext)ctx);
    }
}

