/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.commands;

import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.yukkuric.hexparse.hooks.HexParseCommands;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgPullClipboard;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.function.BiConsumer;
import miyucomics.hexcellular.StateStorage;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class CommandPropertyIO {
    public static void init() {
        ArgumentBuilder sub_property = HexParseCommands.registerLine(ctx -> CommandPropertyIO.propertyOp((CommandContext<CommandSourceStack>)ctx, CommandPropertyIO::readProp), (ArgumentBuilder[])new ArgumentBuilder[]{Commands.m_82127_((String)"property"), Commands.m_82127_((String)"read"), Commands.m_82129_((String)"propName", (ArgumentType)StringArgumentType.string())});
        HexParseCommands.registerLine(ctx -> CommandPropertyIO.propertyOp((CommandContext<CommandSourceStack>)ctx, CommandPropertyIO::writeProp), (ArgumentBuilder[])new ArgumentBuilder[]{sub_property, Commands.m_82127_((String)"write"), Commands.m_82129_((String)"propName", (ArgumentType)StringArgumentType.string()), Commands.m_82129_((String)"code", (ArgumentType)StringArgumentType.string())});
        HexParseCommands.registerLine(ctx -> CommandPropertyIO.propertyOp((CommandContext<CommandSourceStack>)ctx, CommandPropertyIO::pullClipboard), (ArgumentBuilder[])new ArgumentBuilder[]{sub_property, Commands.m_82127_((String)"clipboard"), Commands.m_82129_((String)"propName", (ArgumentType)StringArgumentType.string())});
    }

    static int propertyOp(CommandContext<CommandSourceStack> ctx, @NotNull BiConsumer<String, CommandContext<CommandSourceStack>> action) {
        String propName = StringArgumentType.getString(ctx, (String)"propName");
        propName = (String)StringProcessors.APPEND_UNDERLINE.apply(propName);
        action.accept(propName, ctx);
        return 1;
    }

    static void readProp(String propName, CommandContext<CommandSourceStack> ctx) {
        Iota data = StateStorage.Companion.getProperty(((CommandSourceStack)ctx.getSource()).m_81372_(), propName);
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        String code = ParserMain.ParseIotaNbt(HexIotaTypes.serialize((Iota)data), player, StringProcessors.READ_DEFAULT);
        CodeHelpers.displayCode(player, code);
    }

    static void writeProp(String propName, CommandContext<CommandSourceStack> ctx) {
        String code = StringArgumentType.getString(ctx, (String)"code");
        CompoundTag nbt = ParserMain.ParseCode(code, ((CommandSourceStack)ctx.getSource()).m_230896_());
        ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
        StateStorage.Companion.setProperty(world, propName, HexIotaTypes.deserialize((CompoundTag)nbt, (ServerLevel)world));
    }

    static void pullClipboard(String propName, CommandContext<CommandSourceStack> ctx) {
        MsgHandlers.SERVER.sendPacketToPlayer(((CommandSourceStack)ctx.getSource()).m_230896_(), new MsgPullClipboard(propName, ClipboardMsgMode.WRITE_PROPERTY));
    }
}

