/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.hooks;

import io.yukkuric.hexparse.config.HexParseConfig;
import io.yukkuric.hexparse.hooks.PatternMapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class GreatPatternUnlocker
extends SavedData {
    static final String KEY_UNLOCK_SET = "unlocks";
    static final String SAVENAME = "hexparse.great.pattern.unlocks";
    public static GreatPatternUnlocker DENY_ALL = new GreatPatternUnlocker();
    public static GreatPatternUnlocker ALLOW_ALL = new GreatPatternUnlocker(){

        @Override
        public boolean isUnlocked(String key) {
            return true;
        }
    };
    Set<String> _unlocked;

    public GreatPatternUnlocker() {
        this._unlocked = new HashSet<String>();
    }

    public GreatPatternUnlocker(CompoundTag save) {
        try {
            CompoundTag recorder = save.m_128469_(KEY_UNLOCK_SET);
            this._unlocked = new HashSet<String>(recorder.m_128431_());
        }
        catch (Exception e) {
            this._unlocked = new HashSet<String>();
        }
    }

    public CompoundTag m_7176_(CompoundTag save) {
        CompoundTag recorder = new CompoundTag();
        for (String key : this._unlocked) {
            recorder.m_128379_(key, true);
        }
        save.m_128365_(KEY_UNLOCK_SET, (Tag)recorder);
        return save;
    }

    public boolean isUnlocked(String key) {
        key = PatternMapper.ShortNameTracker.getActiveLongName(key);
        return this._unlocked.contains(key);
    }

    public boolean unlock(String key) {
        boolean res = this._unlocked.add(key = PatternMapper.ShortNameTracker.getActiveLongName(key));
        if (res) {
            this.m_77762_();
        }
        return res;
    }

    public boolean lock(String key) {
        boolean res = this._unlocked.remove(key = PatternMapper.ShortNameTracker.getActiveLongName(key));
        if (res) {
            this.m_77762_();
        }
        return res;
    }

    public int unlockAll() {
        int res = 0;
        for (Map.Entry pair : PatternMapper.greatMapper.entrySet()) {
            ResourceLocation id = (ResourceLocation)pair.getKey();
            if (!this.unlock(id.toString())) continue;
            ++res;
        }
        if (res > 0) {
            this.m_77762_();
        }
        return res;
    }

    public int clear() {
        if (this._unlocked.isEmpty()) {
            return 0;
        }
        this.m_77762_();
        int res = this._unlocked.size();
        this._unlocked.clear();
        return res;
    }

    public static GreatPatternUnlocker get(ServerLevel level) {
        HexParseConfig.ParseGreatPatternMode cfg = HexParseConfig.canParseGreatPatterns();
        if (cfg == HexParseConfig.ParseGreatPatternMode.DISABLED) {
            return DENY_ALL;
        }
        if (cfg == HexParseConfig.ParseGreatPatternMode.ALL) {
            return ALLOW_ALL;
        }
        level = level.m_7654_().m_129783_();
        DimensionDataStorage ds = level.m_8895_();
        return (GreatPatternUnlocker)ds.m_164861_(GreatPatternUnlocker::new, GreatPatternUnlocker::new, SAVENAME);
    }
}

