/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.hooks;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.math.HexDir;
import com.mojang.datafixers.util.Pair;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.CommentIotaType;
import io.yukkuric.hexparse.parsers.IotaFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class PatternMapper {
    static final ConcurrentMap<String, Object> staticMapper;
    public static final ConcurrentMap<ResourceLocation, Object> greatMapper;
    static final Method m_opId;
    static final Method m_preferredStart;
    public static final Map<String, CompoundTag> mapPattern;
    public static final Map<String, CompoundTag> mapPatternWorld;

    static void _setMap(Map<String, CompoundTag> map, ResourceLocation id, String seq, HexDir dir) {
        String idLong = id.toString();
        String idShort = id.m_135815_();
        CompoundTag pattern = IotaFactory.makePattern(seq, dir);
        map.put(idLong, pattern);
        if (ShortNameTracker.recordNewShortName(id)) {
            map.put(idShort, pattern);
        }
    }

    public static void init(ServerLevel level) {
        ShortNameTracker.clear(level);
        level.m_7654_().m_129783_().m_8895_().m_164855_("hex.per-world-patterns", (SavedData)PatternRegistry.Save.create((long)level.m_7328_()));
        try {
            HexDir dir;
            ResourceLocation id;
            Object entry;
            String seq;
            for (Map.Entry pair : staticMapper.entrySet()) {
                seq = (String)pair.getKey();
                entry = pair.getValue();
                id = (ResourceLocation)m_opId.invoke(entry, new Object[0]);
                dir = (HexDir)m_preferredStart.invoke(entry, new Object[0]);
                PatternMapper._setMap(mapPattern, id, seq, dir);
            }
            for (Map.Entry pair : PatternRegistry.getPerWorldPatterns((ServerLevel)level).entrySet()) {
                seq = (String)pair.getKey();
                entry = (Pair)pair.getValue();
                id = (ResourceLocation)entry.getFirst();
                dir = (HexDir)entry.getSecond();
                PatternMapper._setMap(mapPatternWorld, id, seq, dir);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void initLocal() {
        try {
            for (Map.Entry pair : staticMapper.entrySet()) {
                String seq = (String)pair.getKey();
                Object entry = pair.getValue();
                ResourceLocation id = (ResourceLocation)m_opId.invoke(entry, new Object[0]);
                HexDir dir = (HexDir)m_preferredStart.invoke(entry, new Object[0]);
                PatternMapper._setMap(mapPattern, id, seq, dir);
            }
            String fooSeq = CommentIotaType.COMMENT_PATTERN.anglesSignature();
            for (ResourceLocation id : greatMapper.keySet()) {
                PatternMapper._setMap(mapPatternWorld, id, fooSeq, HexDir.EAST);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapPattern = new HashMap<String, CompoundTag>();
        mapPatternWorld = new HashMap<String, CompoundTag>();
        try {
            Field fStaticMapper = PatternRegistry.class.getDeclaredField("regularPatternLookup");
            fStaticMapper.setAccessible(true);
            staticMapper = (ConcurrentMap)fStaticMapper.get(null);
            fStaticMapper = PatternRegistry.class.getDeclaredField("perWorldPatternLookup");
            fStaticMapper.setAccessible(true);
            greatMapper = (ConcurrentMap)fStaticMapper.get(null);
            Class<?> clsRegularEntry = Class.forName("at.petrak.hexcasting.api.PatternRegistry$RegularEntry");
            m_opId = clsRegularEntry.getMethod("opId", new Class[0]);
            m_opId.setAccessible(true);
            m_preferredStart = clsRegularEntry.getMethod("preferredStart", new Class[0]);
            m_preferredStart.setAccessible(true);
            mapPattern.put("\\", IotaFactory.makePattern("qqqaw", HexDir.WEST));
            mapPattern.put("(", IotaFactory.makePattern("qqq", HexDir.WEST));
            mapPattern.put(")", IotaFactory.makePattern("eee", HexDir.EAST));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ShortNameTracker {
        public static final Map<String, CompoundTag>[] modifyTargets = new Map[]{mapPattern, mapPatternWorld};
        public static final Map<String, Set<ResourceLocation>> allPointed = new HashMap<String, Set<ResourceLocation>>();
        public static final Map<String, ResourceLocation> mapActiveShortName = new HashMap<String, ResourceLocation>();
        public static final Set<String> shortNameWithConflicts = new HashSet<String>();
        private static ShortNameTrackerPersistent manualTargets;

        static boolean recordNewShortName(ResourceLocation id) {
            boolean imBoss;
            String shortName = id.m_135815_();
            String longName = id.toString();
            Set locList = allPointed.computeIfAbsent(shortName, k -> new HashSet());
            locList.add(id);
            if (locList.size() > 1) {
                shortNameWithConflicts.add(shortName);
            }
            ResourceLocation idExist = mapActiveShortName.get(shortName);
            boolean manualSelected = false;
            boolean manualOld = false;
            if (manualTargets != null) {
                String selectedLong = manualTargets.get(shortName);
                manualSelected = longName.equals(selectedLong);
                manualOld = !StringUtil.m_14408_((String)selectedLong);
            }
            boolean bl = imBoss = manualSelected || !manualOld && id.m_135827_().equals("hexcasting");
            if (idExist == null || imBoss) {
                mapActiveShortName.put(shortName, id);
                return true;
            }
            return false;
        }

        static void clear(ServerLevel level) {
            allPointed.clear();
            mapActiveShortName.clear();
            shortNameWithConflicts.clear();
            manualTargets = ShortNameTrackerPersistent.get(level);
        }

        public static String getActiveLongName(String shortName) {
            ResourceLocation id = mapActiveShortName.get(shortName);
            return id == null ? shortName : id.toString();
        }

        public static void redirectShortName(String shortName, ResourceLocation newId) {
            Set<ResourceLocation> validIdSet = allPointed.get(shortName);
            if (validIdSet == null || !shortNameWithConflicts.contains(shortName)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.name", new Object[0])));
            }
            if (!validIdSet.contains(newId)) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, HexParse.doTranslate("hexparse.cmd.conflict.error.id", newId)));
            }
            String longName = newId.toString();
            boolean found = false;
            for (Map<String, CompoundTag> map : modifyTargets) {
                CompoundTag tryLongEntry;
                map.remove(shortName);
                if (found || (tryLongEntry = map.get(longName)) == null) continue;
                found = true;
                map.put(shortName, tryLongEntry);
            }
            if (!found) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.cmd.conflict.error", shortName, "excuse me WTF?"));
            }
            mapActiveShortName.put(shortName, newId);
            if (manualTargets != null) {
                manualTargets.put(shortName, longName);
            }
        }
    }

    private static class ShortNameTrackerPersistent
    extends SavedData {
        static final String SAVENAME = "hexparse.short_name.settings";
        static final CompoundTag settings = new CompoundTag();

        ShortNameTrackerPersistent() {
        }

        ShortNameTrackerPersistent(CompoundTag load) {
            settings.m_128391_(load);
        }

        static ShortNameTrackerPersistent get(ServerLevel level) {
            DimensionDataStorage ds = level.m_8895_();
            return (ShortNameTrackerPersistent)ds.m_164861_(ShortNameTrackerPersistent::new, ShortNameTrackerPersistent::new, SAVENAME);
        }

        @NotNull
        public CompoundTag m_7176_(CompoundTag body) {
            body.m_128391_(settings);
            return body;
        }

        public String get(String shortName) {
            return settings.m_128461_(shortName);
        }

        public void put(String shortName, String longName) {
            settings.m_128359_(shortName, longName);
        }
    }
}

