/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.macro;

import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.macro.MacroManager;
import io.yukkuric.hexparse.parsers.CodeCutter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;

public class MacroProcessor
implements Iterator<String> {
    final Iterator<String> source;
    final Set<String> usedMacros;
    final ServerPlayer player;
    MacroProcessor inner;
    String innerMacroName;
    String cachedNext;
    RuntimeException cachedError;
    int count;

    public MacroProcessor(Iterator<String> source, ServerPlayer player) {
        this(source, player, new HashSet<String>());
    }

    MacroProcessor(Iterator<String> src, ServerPlayer caller, Set<String> used) {
        this.source = src;
        this.usedMacros = used;
        this.player = caller;
        this.cachedNext = this.calcCache();
    }

    String calcCache() {
        if (this.inner != null && this.inner.hasNext()) {
            return this.inner.next();
        }
        if (this.inner != null) {
            this.usedMacros.remove(this.innerMacroName);
            this.inner = null;
        }
        if (!this.source.hasNext()) {
            return null;
        }
        String raw = this.source.next();
        boolean isMacro = MacroManager.isMacro(raw);
        if (isMacro && this.usedMacros.contains(raw)) {
            this.cachedError = new RuntimeException(HexParse.doTranslate("hexparse.msg.error.used_macro", raw));
            return "ERROR";
        }
        String mapped = MacroManager.getMacro(this.player, raw);
        if (mapped == null) {
            return raw;
        }
        if (!isMacro) {
            return mapped;
        }
        this.usedMacros.add(raw);
        try {
            this.inner = new MacroProcessor(CodeCutter.splitCode(mapped).iterator(), this.player, this.usedMacros);
        }
        catch (Throwable e) {
            this.cachedError = new RuntimeException(e);
            return "ERROR";
        }
        this.innerMacroName = raw;
        return this.calcCache();
    }

    @Override
    public boolean hasNext() {
        return this.cachedNext != null;
    }

    @Override
    public String next() {
        if (this.cachedError != null) {
            throw this.cachedError;
        }
        ++this.count;
        if (this.count >= 1024) {
            throw new RuntimeException(HexParse.doTranslate("hexcasting.mishap.stack_size", new Object[0]));
        }
        String res = this.cachedNext;
        this.cachedNext = this.calcCache();
        return res;
    }
}

