/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.misc;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.misc.HexDamageSources;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.mishaps.Mishap;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemSpellbook;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.hooks.GreatPatternUnlocker;
import io.yukkuric.hexparse.hooks.PatternMapper;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class CodeHelpers {
    static WeakReference<MinecraftServer> refreshedWorld = new WeakReference<Object>(null);
    static boolean refreshedLocal = false;

    public static void doExtractMedia(ServerPlayer caster, int amount) {
        ADMediaHolder source;
        CastingHarness harness = IXplatAbstractions.INSTANCE.getHarness(caster, InteractionHand.MAIN_HAND);
        int costLeft = amount;
        List mediaSources = DiscoveryHandlers.collectMediaHolders((CastingHarness)harness);
        mediaSources.sort(Collections.reverseOrder(MediaHelper::compareMediaItem));
        Iterator iterator = mediaSources.iterator();
        while (iterator.hasNext() && (costLeft -= MediaHelper.extractMedia((ADMediaHolder)(source = (ADMediaHolder)iterator.next()), (int)costLeft, (boolean)false, (boolean)false)) > 0) {
        }
        if (costLeft > 0) {
            double mediaToHealth = HexConfig.common().mediaToHealthRate();
            double healthToRemove = Math.max((double)costLeft / mediaToHealth, 0.5);
            double mediaAbleToCastFromHP = (double)caster.m_21223_() * mediaToHealth;
            Mishap.Companion.trulyHurt((LivingEntity)caster, (DamageSource)HexDamageSources.OVERCAST, (float)healthToRemove);
            int actuallyTaken = (int)Math.ceil(mediaAbleToCastFromHP - (double)caster.m_21223_() * mediaToHealth);
            HexAdvancementTriggers.OVERCAST_TRIGGER.trigger(caster, actuallyTaken);
            caster.m_36222_(HexStatistics.MEDIA_OVERCAST, amount - costLeft);
        }
    }

    public static IOMethod getItemIO(ServerPlayer player) {
        if (player == null) {
            return null;
        }
        IOMethod ret = IOMethod.get(player.m_21205_());
        if (ret == null) {
            ret = IOMethod.get(player.m_21206_());
        }
        return ret;
    }

    public static void doParse(ServerPlayer player, String code, String rename) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return;
        }
        CompoundTag nbt = ParserMain.ParseCode(code, player);
        target.write(nbt);
        if (rename != null) {
            target.rename(rename);
        }
    }

    public static void doParse(ServerPlayer player, List<String> code, String rename) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return;
        }
        CompoundTag nbt = ParserMain.ParseCode(code, player);
        target.write(nbt);
        if (rename != null) {
            target.rename(rename);
        }
    }

    public static String readHand(ServerPlayer player) {
        return CodeHelpers.readHand(player, StringProcessors.READ_DEFAULT);
    }

    public static String readHand(ServerPlayer player, StringProcessors.F post) {
        IOMethod target = CodeHelpers.getItemIO(player);
        if (target == null) {
            return null;
        }
        CompoundTag iotaRoot = target.read();
        if (iotaRoot == null) {
            return null;
        }
        CodeHelpers.autoRefresh(player.m_20194_());
        return ParserMain.ParseIotaNbt(iotaRoot, player, post);
    }

    public static void autoRefresh(MinecraftServer server) {
        if (!refreshedWorld.refersTo(server)) {
            ServerLevel level = server.m_129783_();
            HexParse.LOGGER.info("auto refresh for server: {}, level: {}", (Object)server.m_7326_(), (Object)level);
            PatternMapper.init(level);
            refreshedLocal = true;
            refreshedWorld = new WeakReference<MinecraftServer>(server);
        }
    }

    public static void autoRefreshLocal() {
        if (refreshedLocal) {
            return;
        }
        PatternMapper.initLocal();
        refreshedLocal = true;
    }

    public static void displayCode(ServerPlayer player, String code) {
        if (player == null || code == null) {
            return;
        }
        MutableComponent display = Component.m_237110_((String)"hexparse.cmd.read.display", (Object[])new Object[]{Component.m_237113_((String)code).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN);
        player.m_213846_((Component)CodeHelpers.wrapClickCopy(display, code));
    }

    public static MutableComponent wrapClickCopy(MutableComponent component, String code) {
        return component.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, code)).m_131144_(HoverEvent.Action.f_130831_.m_130854_((Component)Component.m_237115_((String)"chat.copy.click"))));
    }

    public static MutableComponent wrapClickSuggest(MutableComponent component, String command) {
        return component.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)).m_131144_(HoverEvent.Action.f_130831_.m_130854_((Component)Component.m_237113_((String)command))));
    }

    public static Component getPatternDisplay(ResourceLocation id, ServerLevel level) {
        String longName = id.toString();
        if (PatternMapper.mapPatternWorld.containsKey(longName) && !GreatPatternUnlocker.get(level).isUnlocked(longName)) {
            return Component.m_237113_((String)"???");
        }
        CompoundTag rawIota = null;
        for (Map<String, CompoundTag> map : PatternMapper.ShortNameTracker.modifyTargets) {
            if (!map.containsKey(longName)) continue;
            rawIota = map.get(longName);
            break;
        }
        if (rawIota == null) {
            return Component.m_237113_((String)"NULL");
        }
        return HexIotaTypes.getDisplay(rawIota);
    }

    public static Component dumpError(MutableComponent raw, Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String trace = sw.toString();
        return raw.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, trace)).m_131144_(HoverEvent.Action.f_130831_.m_130854_((Component)Component.m_237113_((String)trace))));
    }

    public static class IOMethod {
        private final BiConsumer<ItemStack, CompoundTag> writer;
        private final Function<ItemStack, CompoundTag> reader;
        private ItemStack current;
        private static Map<Class<? extends IotaHolderItem>, IOMethod> ITEM_IO_TYPES = new HashMap<Class<? extends IotaHolderItem>, IOMethod>();

        public IOMethod(Class<? extends IotaHolderItem> cls, BiConsumer<ItemStack, CompoundTag> writer, Function<ItemStack, CompoundTag> reader) {
            this.reader = reader;
            this.writer = writer;
            ITEM_IO_TYPES.put(cls, this);
        }

        public void write(CompoundTag nbt) {
            this.writer.accept(this.current, nbt);
        }

        public CompoundTag read() {
            if (this.reader == null) {
                return ((IotaHolderItem)this.current.m_41720_()).readIotaTag(this.current);
            }
            return this.reader.apply(this.current);
        }

        public void bind(ItemStack stack) {
            this.current = stack;
        }

        public void rename(String newName) {
            this.current.m_41714_((Component)Component.m_237113_((String)newName));
        }

        public Iota readIota(ServerLevel world) {
            return ((IotaHolderItem)this.current.m_41720_()).readIota(this.current, world);
        }

        static IOMethod get(ItemStack stack) {
            if (stack == null) {
                return null;
            }
            IOMethod ret = ITEM_IO_TYPES.get(stack.m_41720_().getClass());
            if (ret != null) {
                ret.bind(stack);
            }
            return ret;
        }

        static {
            BiConsumer<ItemStack, CompoundTag> simpleWrite = (target, nbt) -> target.m_41784_().m_128365_("data", (Tag)nbt);
            new IOMethod(ItemFocus.class, simpleWrite, null);
            new IOMethod(ItemSpellbook.class, (stack, nbt) -> {
                int idx = ItemSpellbook.getPage((ItemStack)stack, (int)1);
                String pageKey = String.valueOf(idx);
                NBTHelper.getOrCreateCompound((ItemStack)stack, (String)ItemSpellbook.TAG_PAGES).m_128365_(pageKey, (Tag)nbt);
            }, null);
        }
    }
}

