/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.network;

import at.petrak.hexcasting.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import io.yukkuric.hexparse.misc.CodeHelpers;
import io.yukkuric.hexparse.network.ClipboardMsgMode;
import io.yukkuric.hexparse.network.MsgHandlers;
import io.yukkuric.hexparse.network.MsgHelpers;
import io.yukkuric.hexparse.network.MsgPushClipboard;
import io.yukkuric.hexparse.parsers.ParserMain;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record MsgPullClipboard(String rename, ClipboardMsgMode mode) implements IMessage
{
    public static final ResourceLocation ID = new ResourceLocation("hexparse", "clipboard/pull");
    static Pattern ANGLES = Pattern.compile("(?<=\")[wedsaq]*(?=\")");
    static int MAX_LENGTH = 102400;

    public void serialize(FriendlyByteBuf buf) {
        buf.writeByte(this.mode.ordinal());
        MsgHelpers.putString(buf, this.rename);
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgPullClipboard deserialize(ByteBuf buffer) {
        ClipboardMsgMode mode;
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        try {
            mode = ClipboardMsgMode.values()[buf.readByte()];
        }
        catch (Throwable e) {
            mode = ClipboardMsgMode.INVALID;
        }
        String name = MsgHelpers.getString(buf);
        return new MsgPullClipboard(name, mode);
    }

    public static void handle(MsgPullClipboard self) {
        Minecraft MC = Minecraft.m_91087_();
        MC.execute(() -> {
            String code = MC.f_91068_.m_90876_();
            if (code.isBlank()) {
                return;
            }
            if (self.mode == ClipboardMsgMode.ANGLES_ONLY) {
                Stream<String> matched = ANGLES.matcher(code).results().map(x -> "_" + x.group());
                code = String.join((CharSequence)" ", matched.toList());
            }
            if (code.length() > MAX_LENGTH) {
                if (MC.f_91074_ != null) {
                    MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"hexparse.msg.error.code_too_long", (Object[])new Object[]{code.length()}));
                }
                return;
            }
            CodeHelpers.autoRefreshLocal();
            if (self.mode != ClipboardMsgMode.INVALID) {
                MsgHandlers.CLIENT.sendPacketToServer(new MsgPushClipboard(ParserMain.preMatchClipboardClient(code), self.rename, self.mode));
            }
        });
    }
}

