/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers;

import at.petrak.hexcasting.api.spell.math.HexDir;
import io.yukkuric.hexparse.HexParse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class IotaFactory {
    public static final String TYPE_LIST = "hexcasting:list";
    public static final String TYPE_PATTERN = "hexcasting:pattern";
    public static final String TYPE_DOUBLE = "hexcasting:double";
    public static final String TYPE_VECTOR = "hexcasting:vec3";
    public static final String TYPE_ENTITY = "hexcasting:entity";
    public static final String TYPE_BOOLEAN = "hexcasting:boolean";
    public static final String TYPE_NULL = "hexcasting:null";
    public static final String TYPE_GARBAGE = "hexcasting:garbage";
    public static final String GREAT_PLACEHOLDER_PREFIX = "<";
    public static final String GREAT_PLACEHOLDER_POSTFIX = "?>";
    static final Map<Character, Byte> ANGLE_MAP = new HashMap<Character, Byte>(){
        {
            this.put(Character.valueOf('w'), (byte)0);
            this.put(Character.valueOf('e'), (byte)1);
            this.put(Character.valueOf('d'), (byte)2);
            this.put(Character.valueOf('s'), (byte)3);
            this.put(Character.valueOf('a'), (byte)4);
            this.put(Character.valueOf('q'), (byte)5);
        }
    };

    public static CompoundTag makeType(String type, Tag data) {
        CompoundTag res = new CompoundTag();
        res.m_128359_("hexcasting:type", type);
        res.m_128365_("hexcasting:data", data);
        return res;
    }

    public static CompoundTag makeList(ListTag data) {
        return IotaFactory.makeType(TYPE_LIST, (Tag)data);
    }

    public static CompoundTag makePattern(String angles, HexDir start) {
        ArrayList<Byte> angleArray = new ArrayList<Byte>();
        for (char chr : angles.toCharArray()) {
            if (!ANGLE_MAP.containsKey(Character.valueOf(chr))) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.illegal_pattern_angle", Character.valueOf(chr), angles));
            }
            angleArray.add(ANGLE_MAP.get(Character.valueOf(chr)));
        }
        CompoundTag pattern = new CompoundTag();
        pattern.m_128344_("start_dir", (byte)start.ordinal());
        pattern.m_177853_("angles", angleArray);
        return IotaFactory.makeType(TYPE_PATTERN, (Tag)pattern);
    }

    public static CompoundTag makeComment(String comment) {
        return IotaFactory.makeType("hexparse:comment", (Tag)StringTag.m_129297_((String)comment));
    }

    public static boolean isGreatPatternPlaceholder(String node) {
        return node.startsWith(GREAT_PLACEHOLDER_PREFIX) && node.endsWith(GREAT_PLACEHOLDER_POSTFIX);
    }

    public static String makeUnknownGreatPatternText(String id) {
        return GREAT_PLACEHOLDER_PREFIX + id + GREAT_PLACEHOLDER_POSTFIX;
    }

    public static CompoundTag makeUnknownGreatPattern(String id) {
        return IotaFactory.makeComment(IotaFactory.makeUnknownGreatPatternText(id));
    }

    public static CompoundTag makeTab(int num) {
        return IotaFactory.makeComment("\n" + " ".repeat(num));
    }

    public static CompoundTag makeNum(Double num) {
        return IotaFactory.makeType(TYPE_DOUBLE, (Tag)DoubleTag.m_128500_((double)num));
    }
}

