/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers;

import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.parsers.IotaFactory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PluginIotaFactory
extends IotaFactory {
    public static final String TYPE_IOTA_TYPE = "hexal:iota_type";
    public static final String TYPE_ENTITY_TYPE = "hexal:entity_type";
    public static final String TYPE_ITEM_TYPE = "hexal:item_type";
    public static final String TYPE_STRING = "moreiotas:string";
    public static final String TYPE_MATRIX = "moreiotas:matrix";
    public static final String TYPE_GATE = "hexal:gate";
    public static final String TYPE_MOTE = "hexal:item";
    public static final String TYPE_PROP = "hexcellular:property";
    public static final String TYPE_RESLOC = "hexpose:identifier";

    public static CompoundTag makeIotaType(String type) {
        return PluginIotaFactory.makeType(TYPE_IOTA_TYPE, (Tag)StringTag.m_129297_((String)type));
    }

    public static CompoundTag makeEntityType(String type) {
        return PluginIotaFactory.makeType(TYPE_ENTITY_TYPE, (Tag)StringTag.m_129297_((String)type));
    }

    public static CompoundTag makeItemType(String type, boolean isBlock) {
        CompoundTag body = new CompoundTag();
        body.m_128359_(isBlock ? "block" : "item", type);
        return PluginIotaFactory.makeType(TYPE_ITEM_TYPE, (Tag)body);
    }

    public static CompoundTag makeItemType(String type) {
        return PluginIotaFactory.makeItemType(type, false);
    }

    public static CompoundTag makeBlockType(String type) {
        return PluginIotaFactory.makeItemType(type, true);
    }

    public static CompoundTag makeString(String data) {
        return PluginIotaFactory.makeType(TYPE_STRING, (Tag)StringTag.m_129297_((String)data));
    }

    public static CompoundTag makeMatrix(String[] raw) {
        int ncol;
        int nrow;
        CompoundTag body = new CompoundTag();
        int ptr = 1;
        int targetSize = 3;
        if (raw.length < targetSize) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.data_amount", raw.length, targetSize));
        }
        try {
            nrow = Integer.parseInt(raw[ptr]);
            if (nrow <= 0) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.size", nrow));
            }
            body.m_128405_("rows", nrow);
            ncol = Integer.parseInt(raw[++ptr]);
            if (ncol <= 0) {
                throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.size", ncol));
            }
            ++ptr;
            body.m_128405_("cols", ncol);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.size", raw[ptr]));
        }
        targetSize = nrow * ncol;
        if (raw.length - 3 < targetSize) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.data_amount", raw.length - 3, targetSize));
        }
        ListTag data = new ListTag();
        try {
            for (int i = 0; i < nrow; ++i) {
                ListTag row = new ListTag();
                for (int j = 0; j < ncol; ++j) {
                    row.add((Object)DoubleTag.m_128500_((double)Double.parseDouble(raw[ptr])));
                    ++ptr;
                }
                data.add((Object)row);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(HexParse.doTranslate("hexparse.msg.error.matrix.value", raw[ptr]));
        }
        body.m_128365_("mat", (Tag)data);
        return PluginIotaFactory.makeType(TYPE_MATRIX, (Tag)body);
    }

    public static CompoundTag makeProperty(CompoundTag packed) {
        return PluginIotaFactory.makeType(TYPE_PROP, (Tag)packed);
    }

    public static CompoundTag makeGate(int id, Vec3 pos, Entity binder) {
        byte type = 0;
        if (binder != null) {
            type = 2;
            if (pos == null) {
                pos = Vec3.f_82478_;
            }
        } else if (pos != null) {
            type = 1;
        }
        CompoundTag payload = new CompoundTag();
        payload.m_128405_("index", id);
        payload.m_128344_("target_type", type);
        if (pos != null) {
            payload.m_128347_("target_x", pos.f_82479_);
            payload.m_128347_("target_y", pos.f_82480_);
            payload.m_128347_("target_z", pos.f_82481_);
        }
        if (binder != null) {
            payload.m_128362_("target_uuid", binder.m_20148_());
            payload.m_128359_("target_name", binder.m_7755_().getString());
        }
        return PluginIotaFactory.makeType(TYPE_GATE, (Tag)payload);
    }

    public static CompoundTag makeResLoc(String raw) {
        ResourceLocation resloc = new ResourceLocation(raw);
        CompoundTag res = new CompoundTag();
        res.m_128359_("path", resloc.m_135815_());
        res.m_128359_("namespace", resloc.m_135827_());
        return PluginIotaFactory.makeType(TYPE_RESLOC, (Tag)res);
    }
}

