/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.nbt2str;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.spell.Action;
import at.petrak.hexcasting.api.spell.ConstMediaAction;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.iota.DoubleIota;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidPattern;
import at.petrak.hexcasting.common.casting.operators.stack.OpMask;
import com.mojang.datafixers.util.Pair;
import io.yukkuric.hexparse.hooks.PatternMapper;
import io.yukkuric.hexparse.parsers.IPlayerBinder;
import io.yukkuric.hexparse.parsers.nbt2str.INbt2Str;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;

public class PatternParser
implements INbt2Str,
IPlayerBinder {
    static Map<String, String> SPECIAL_PATTERNS = new HashMap<String, String>(){
        {
            this.put("qqq", "(");
            this.put("eee", ")");
            this.put("qqqaw", "\\");
        }
    };
    static List<Iota> FOO_LIST = List.of();
    ServerLevel level;
    ServerPlayer player;

    @Override
    public boolean match(CompoundTag node) {
        return this.isType(node, "hexcasting:pattern");
    }

    @Override
    public String parse(CompoundTag node) {
        HexPattern pattern = HexPattern.fromNBT((CompoundTag)node.m_128469_("hexcasting:data"));
        String angleSigs = pattern.anglesSignature();
        if (SPECIAL_PATTERNS.containsKey(angleSigs)) {
            return SPECIAL_PATTERNS.get(angleSigs);
        }
        try {
            Pair matcher = PatternRegistry.matchPatternAndID((HexPattern)pattern, (ServerLevel)this.level);
            Action action = (Action)matcher.getFirst();
            ResourceLocation opId = (ResourceLocation)matcher.getSecond();
            String opIdStr = opId.toString();
            if (opIdStr.equals("hexcasting:mask")) {
                StringBuilder maskBuilder = new StringBuilder("mask_");
                for (Boolean m : ((OpMask)action).getMask()) {
                    maskBuilder.append(m != false ? (char)'-' : 'v');
                }
                return maskBuilder.toString();
            }
            if (opIdStr.equals("hexcasting:number")) {
                List constInner = ((ConstMediaAction)action).execute(FOO_LIST, new CastingContext(this.player, InteractionHand.MAIN_HAND, CastingContext.CastSource.STAFF));
                return "num_" + this.displayMinimal(((DoubleIota)constInner.get(0)).getDouble());
            }
            if (!PatternMapper.mapPattern.containsKey(opIdStr) && !PatternMapper.mapPatternWorld.containsKey(opIdStr)) {
                throw new MishapInvalidPattern();
            }
            if (opId.m_135827_().equals("hexcasting")) {
                return opId.m_135815_();
            }
            return opIdStr;
        }
        catch (MishapInvalidPattern mishapInvalidPattern) {
            return "_" + angleSigs;
        }
    }

    @Override
    public void BindPlayer(ServerPlayer p) {
        this.player = p;
        this.level = (ServerLevel)p.f_19853_;
    }
}

