/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.nbt2str.plugins;

import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.parsers.nbt2str.INbt2Str;
import net.minecraft.nbt.CompoundTag;

public class StringParser
implements INbt2Str {
    String type;
    String prefix;
    StringProcessors.F[] processors;
    public static StringParser IOTA = new StringParser("hexal:iota_type", "type_", StringProcessors.OMIT_HEX);
    public static StringParser ENTITY = new StringParser("hexal:entity_type", "type/entity_", StringProcessors.OMIT_MC);
    public static StringParser STRING = new StringParser("moreiotas:string", "str_", new StringProcessors.F[0]);

    StringParser(String type, String prefix, StringProcessors.F ... processors) {
        this.type = type;
        this.prefix = prefix;
        this.processors = processors;
    }

    @Override
    public boolean match(CompoundTag node) {
        return this.isType(node, this.type);
    }

    @Override
    public String parse(CompoundTag node) {
        String raw = node.m_128461_("hexcasting:data");
        for (StringProcessors.F f : this.processors) {
            raw = (String)f.apply(raw);
        }
        return this.prefix + raw;
    }
}

