/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.str2nbt;

import at.petrak.hexcasting.api.spell.iota.EntityIota;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.spell.mishaps.MishapOthersName;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import io.yukkuric.hexparse.HexParse;
import io.yukkuric.hexparse.parsers.IPlayerBinder;
import io.yukkuric.hexparse.parsers.str2nbt.BaseConstParser;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ToEntity
extends BaseConstParser.Prefix
implements IPlayerBinder {
    ServerPlayer self;
    ServerLevel level;

    public ToEntity() {
        super("entity");
    }

    @Override
    public void BindPlayer(ServerPlayer p) {
        this.self = p;
        this.level = p.m_9236_();
    }

    @Override
    public CompoundTag parse(String node) {
        NullIota res;
        Entity entity = null;
        try {
            Player p;
            UUID uuid = UUID.fromString(node.substring(7));
            entity = this.level.m_8791_(uuid);
            if (entity instanceof Player && !this.self.equals((Object)(p = (Player)entity))) {
                throw new MishapOthersName(p);
            }
            res = new EntityIota(entity);
        }
        catch (MishapOthersName e) {
            String msg = HexParse.doTranslate("hexcasting.mishap.others_name", entity.m_7755_());
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            res = new NullIota();
        }
        return HexIotaTypes.serialize((Iota)res);
    }
}

