/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.str2nbt;

import io.yukkuric.hexparse.hooks.GreatPatternUnlocker;
import io.yukkuric.hexparse.hooks.PatternMapper;
import io.yukkuric.hexparse.parsers.IPlayerBinder;
import io.yukkuric.hexparse.parsers.IotaFactory;
import io.yukkuric.hexparse.parsers.str2nbt.IStr2Nbt;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class ToPattern
implements IStr2Nbt {
    final Map<String, CompoundTag> target;
    public static ToPattern NORMAL = new ToPattern(PatternMapper.mapPattern);
    public static ToGreatPattern GREAT = new ToGreatPattern(PatternMapper.mapPatternWorld);

    ToPattern(Map<String, CompoundTag> target) {
        this.target = target;
    }

    @Override
    public boolean match(String node) {
        return this.target.containsKey(node);
    }

    @Override
    public CompoundTag parse(String node) {
        return this.target.get(node);
    }

    public static class ToGreatPattern
    extends ToPattern
    implements IPlayerBinder {
        GreatPatternUnlocker checker;

        ToGreatPattern(Map<String, CompoundTag> target) {
            super(target);
        }

        @Override
        public void BindPlayer(ServerPlayer p) {
            ServerLevel level = p.m_9236_();
            this.checker = GreatPatternUnlocker.get(level);
        }

        @Override
        public CompoundTag parse(String node) {
            if (this.checker == null || this.checker.isUnlocked(node)) {
                return super.parse(node);
            }
            return IotaFactory.makeUnknownGreatPattern(node);
        }
    }
}

