/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexparse.parsers.str2nbt.plugins;

import io.yukkuric.hexparse.misc.StringEscaper;
import io.yukkuric.hexparse.misc.StringProcessors;
import io.yukkuric.hexparse.parsers.IPlayerBinder;
import io.yukkuric.hexparse.parsers.PluginIotaFactory;
import io.yukkuric.hexparse.parsers.str2nbt.BaseConstParser;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

public class PluginConstParsers {
    public static BaseConstParser TO_ENTITY_TYPE = new Resource("type/entity_", PluginIotaFactory::makeEntityType);
    public static BaseConstParser TO_ITEM_TYPE = new Resource("type/item_", PluginIotaFactory::makeItemType);
    public static BaseConstParser TO_BLOCK_TYPE = new Resource("type/block_", PluginIotaFactory::makeBlockType);
    public static BaseConstParser TO_IOTA_TYPE = new BaseConstParser.Regex("^type(\\/iota)?_"){

        @Override
        public CompoundTag parse(String node) {
            Object type = node.substring(node.indexOf(95) + 1);
            if (((String)type).indexOf(58) < 0) {
                type = "hexcasting:" + (String)type;
            }
            return PluginIotaFactory.makeIotaType((String)type);
        }
    };
    public static BaseConstParser TO_STRING = new BaseConstParser.Prefix("str_"){

        @Override
        public CompoundTag parse(String node) {
            String str = node.substring(node.indexOf(95) + 1);
            return PluginIotaFactory.makeString(str);
        }
    };
    public static BaseConstParser TO_MATRIX = new BaseConstParser.Regex("^mat(rix)?_"){

        @Override
        public CompoundTag parse(String node) {
            return PluginIotaFactory.makeMatrix(node.split("_"));
        }
    };
    public static BaseConstParser TO_PROPERTY = new ToProperty("^prop(erty)?_");
    public static BaseConstParser TO_MY_PROPERTY = new ToProperty.Private("^myprop_");
    public static BaseConstParser TO_STRING_LIT = new BaseConstParser.Prefix("\""){

        @Override
        public CompoundTag parse(String node) {
            node = node.substring(1, node.length() - 1);
            String string = StringEscaper.Companion.unescape(node);
            return PluginIotaFactory.makeString(string);
        }
    };
    public static BaseConstParser TO_IDENTIFIER = new Resource("id_", PluginIotaFactory::makeResLoc);

    static class Resource
    extends BaseConstParser.Prefix {
        Function<String, CompoundTag> subParse;

        public Resource(String prefix, Function<String, CompoundTag> sub) {
            super(prefix);
            this.subParse = sub;
        }

        @Override
        public CompoundTag parse(String node) {
            Object type = node.substring(node.indexOf(95) + 1);
            if (((String)type).indexOf(58) < 0) {
                type = "minecraft:" + (String)type;
            }
            return this.subParse.apply((String)type);
        }
    }

    public static class ToProperty
    extends BaseConstParser.Regex {
        protected ToProperty(String regex) {
            super(regex);
        }

        String getPropValue(String str) {
            return (String)StringProcessors.APPEND_UNDERLINE.apply(str);
        }

        @Override
        public CompoundTag parse(String node) {
            String str = node.substring(node.indexOf(95) + 1);
            CompoundTag packed = new CompoundTag();
            packed.m_128359_("name", this.getPropValue(str));
            return PluginIotaFactory.makeProperty(packed);
        }

        @Override
        public int getCost() {
            return super.getCost() + 100000;
        }

        public static class Private
        extends ToProperty
        implements IPlayerBinder {
            private ServerPlayer owner;

            protected Private(String regex) {
                super(regex);
            }

            @Override
            public void BindPlayer(ServerPlayer p) {
                this.owner = p;
            }

            @Override
            String getPropValue(String str) {
                return "[%s]@%s".formatted(this.owner.m_6302_(), str);
            }
        }
    }
}

