/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.timberhearth.client;

import fr.loudo.timberhearth.audio.VolumeAudio;
import fr.loudo.timberhearth.sound.ModSounds;
import fr.loudo.timberhearth.util.UtilClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class TimberHearthSoundControl {
    private static final SoundInstance TIMBER_HEARTH_INSTANCE = SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvent.createVariableRangeEvent((ResourceLocation)ModSounds.TIMBER_HEARTH), (float)1.0f, (float)0.3f);
    private static final SoundManager soundManager = Minecraft.getInstance().getSoundManager();
    private static final int TOTAL_TICK_RAIN = 100;
    private static final int TOTAL_TICK_CAVE = 60;
    private static SoundType currentSoundType = SoundType.CAVE;
    private static boolean flag;
    private static int tick;
    private static float currentVolume;
    private static float breakVolumePoint;

    public static void reset(boolean flag, SoundType type) {
        breakVolumePoint = -1.0f;
        TimberHearthSoundControl.flag = flag;
        currentSoundType = type;
        if (TimberHearthSoundControl.isTransitioning()) {
            breakVolumePoint = currentVolume;
        }
        if (type == SoundType.RAIN && UtilClient.inCave()) {
            return;
        }
        tick = 0;
    }

    public static void play() {
        TimberHearthSoundControl.stop();
        soundManager.play(TIMBER_HEARTH_INSTANCE);
        ClientLevel level = Minecraft.getInstance().level;
        if (level.isRaining() || level.isThundering()) {
            ((VolumeAudio)soundManager).timberHearth$setVolume(TIMBER_HEARTH_INSTANCE, 0.0f);
        }
    }

    public static void stop() {
        soundManager.stop(TIMBER_HEARTH_INSTANCE);
    }

    public static boolean in() {
        return flag;
    }

    public static boolean out() {
        return !flag;
    }

    public static boolean currentRain() {
        return currentSoundType == SoundType.RAIN;
    }

    public static boolean currentCave() {
        return currentSoundType == SoundType.CAVE;
    }

    public static boolean isTransitioning() {
        return (double)tick / (double)currentSoundType.getTotalTick() < 1.0;
    }

    public static void tick() {
        if (tick < currentSoundType.getTotalTick()) {
            ++tick;
        }
    }

    public static void fade(float partialTick) {
        float volume;
        if (tick == currentSoundType.getTotalTick()) {
            return;
        }
        if (!soundManager.isActive(TIMBER_HEARTH_INSTANCE)) {
            return;
        }
        double t = Mth.clamp((double)(((float)tick + partialTick) / (float)currentSoundType.getTotalTick()), (double)0.0, (double)1.0);
        currentVolume = volume = TimberHearthSoundControl.calculateVolume(t);
        if (volume == 1.0f || volume == 0.0f) {
            breakVolumePoint = -1.0f;
        }
        ((VolumeAudio)soundManager).timberHearth$setVolume(TIMBER_HEARTH_INSTANCE, volume);
    }

    private static float calculateVolume(double t) {
        return (float)(flag ? Mth.lerp((double)t, (double)(breakVolumePoint != -1.0f ? (double)breakVolumePoint : 1.0), (double)0.0) : Mth.lerp((double)t, (double)(breakVolumePoint != -1.0f ? (double)breakVolumePoint : 0.0), (double)1.0));
    }

    public static enum SoundType {
        RAIN(100),
        CAVE(60);

        private final int totalTick;

        private SoundType(int totalTick) {
            this.totalTick = totalTick;
        }

        public int getTotalTick() {
            return this.totalTick;
        }
    }
}

