/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.timberhearth.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.timberhearth.network.PlayTimberHearthSoundS2C;
import fr.loudo.timberhearth.platform.Services;
import fr.loudo.timberhearth.util.UtilCommon;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TimberHearthReSyncCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"timber_hearth").then(((LiteralArgumentBuilder)Commands.literal((String)"resync_song").executes(context -> TimberHearthReSyncCommand.syncMusicForPlayer(((CommandSourceStack)context.getSource()).getPlayer(), (CommandSourceStack)context.getSource()))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).requires(source -> source.hasPermission(2))).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"player");
            return TimberHearthReSyncCommand.syncMusicForPlayers(players, (CommandSourceStack)context.getSource());
        }))));
    }

    private static int syncMusicForPlayer(ServerPlayer player, CommandSourceStack commandSourceStack) {
        if (player == null) {
            return 0;
        }
        double songSecondsBasedOnTime = UtilCommon.getOSTSecondsFromDayTime(player.level().getDayTime());
        Services.PACKET_SENDER.sendToPlayer(player, new PlayTimberHearthSoundS2C(songSecondsBasedOnTime));
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"timber_hearth.command.re_sync.only_player"), false);
        return 1;
    }

    private static int syncMusicForPlayers(Collection<ServerPlayer> players, CommandSourceStack commandSourceStack) {
        players.forEach(player -> TimberHearthReSyncCommand.syncMusicForPlayer(player, commandSourceStack));
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"timber_hearth.command.re_sync.players"), false);
        return 1;
    }
}

