/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.timberhearth.client;

import fr.loudo.timberhearth.sound.ModSounds;
import fr.loudo.timberhearth.util.UtilClient;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;

public class TimberHearthSoundControl {
    private static final class_1113 TIMBER_HEARTH_INSTANCE = class_1109.method_24877((class_3414)class_3414.method_47908((class_2960)ModSounds.TIMBER_HEARTH), (float)1.0f, (float)0.3f);
    private static final class_1144 soundManager = class_310.method_1551().method_1483();
    private static final int TOTAL_TICK_RAIN = 100;
    private static final int TOTAL_TICK_CAVE = 60;
    private static SoundType currentSoundType = SoundType.CAVE;
    private static boolean flag;
    private static int tick;
    private static float currentVolume;
    private static float breakVolumePoint;

    public static void reset(boolean flag, SoundType type) {
        breakVolumePoint = -1.0f;
        TimberHearthSoundControl.flag = flag;
        currentSoundType = type;
        if (TimberHearthSoundControl.isTransitioning()) {
            breakVolumePoint = currentVolume;
        }
        if (type == SoundType.RAIN && UtilClient.inCave()) {
            return;
        }
        tick = 0;
    }

    public static void play() {
        soundManager.method_4873(TIMBER_HEARTH_INSTANCE);
    }

    public static boolean in() {
        return flag;
    }

    public static boolean out() {
        return !flag;
    }

    public static boolean currentRain() {
        return currentSoundType == SoundType.RAIN;
    }

    public static boolean currentCave() {
        return currentSoundType == SoundType.CAVE;
    }

    public static boolean isTransitioning() {
        return (double)tick / (double)currentSoundType.getTotalTick() < 1.0;
    }

    public static void tick() {
        if (tick < currentSoundType.getTotalTick()) {
            ++tick;
        }
    }

    public static void fade(float partialTick) {
        float volume;
        if (tick == currentSoundType.getTotalTick()) {
            return;
        }
        if (!soundManager.method_4877(TIMBER_HEARTH_INSTANCE)) {
            return;
        }
        double t = class_3532.method_15350((double)(((float)tick + partialTick) / (float)currentSoundType.getTotalTick()), (double)0.0, (double)1.0);
        currentVolume = volume = TimberHearthSoundControl.calculateVolume(t);
        if (volume == 1.0f || volume == 0.0f) {
            breakVolumePoint = -1.0f;
        }
        soundManager.method_65258(TIMBER_HEARTH_INSTANCE, volume);
    }

    private static float calculateVolume(double t) {
        return (float)(flag ? class_3532.method_16436((double)t, (double)(breakVolumePoint != -1.0f ? (double)breakVolumePoint : 1.0), (double)0.0) : class_3532.method_16436((double)t, (double)(breakVolumePoint != -1.0f ? (double)breakVolumePoint : 0.0), (double)1.0));
    }

    public static enum SoundType {
        RAIN(100),
        CAVE(60);

        private final int totalTick;

        private SoundType(int totalTick) {
            this.totalTick = totalTick;
        }

        public int getTotalTick() {
            return this.totalTick;
        }
    }
}

