/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.timberhearth.client;

import fr.loudo.timberhearth.audio.SoundExtension;
import fr.loudo.timberhearth.audio.VolumeAudio;
import fr.loudo.timberhearth.sound.ModSounds;
import fr.loudo.timberhearth.util.UtilCommon;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public class TimberHearthSoundControl {
    private static final class_1113 TIMBER_HEARTH_INSTANCE = class_1109.method_24877((class_3414)class_3414.method_47908((class_2960)ModSounds.TIMBER_HEARTH), (float)1.0f, (float)0.3f);
    private static final class_1144 SOUND_MANAGER = class_310.method_1551().method_1483();
    private static final int TOTAL_TICK_RAIN = 100;
    private static final int TOTAL_TICK_JOIN = 40;
    private static final int TOTAL_TICK_DIMENSION = 100;
    private static final int TOTAL_TICK_CAVE = 60;
    private static SoundType currentSoundType = SoundType.RAIN;
    private static boolean flag;
    private static int tick;
    private static float currentVolume;
    private static float breakVolumePoint;

    public static void reset(boolean flag, SoundType type) {
        breakVolumePoint = -1.0f;
        class_638 level = class_310.method_1551().field_1687;
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        if (!UtilCommon.isDayTime(level.method_8532())) {
            return;
        }
        TimberHearthSoundControl.flag = flag;
        currentSoundType = type;
        if (TimberHearthSoundControl.isTransitioning()) {
            breakVolumePoint = currentVolume;
        }
        if (type == SoundType.RAIN && UtilCommon.inCave((class_1937)level, class_310.method_1551().field_1724.method_24515())) {
            return;
        }
        tick = 0;
        if (!SOUND_MANAGER.method_4877(TIMBER_HEARTH_INSTANCE)) {
            ((SoundExtension)SOUND_MANAGER).timberHearth$playAt(TIMBER_HEARTH_INSTANCE, UtilCommon.getOSTSecondsFromDayTime(level.method_8532()));
        }
        if (type == SoundType.JOIN || type == SoundType.DIMENSION) {
            ((VolumeAudio)SOUND_MANAGER).timberHearth$setVolume(TIMBER_HEARTH_INSTANCE, 0.0f);
        }
    }

    public static void disconnect() {
        breakVolumePoint = -1.0f;
        tick = SoundType.RAIN.totalTick;
    }

    public static void play(double seconds) {
        if (UtilCommon.inCave((class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_24515())) {
            return;
        }
        TimberHearthSoundControl.stop();
        ((SoundExtension)SOUND_MANAGER).timberHearth$playAt(TIMBER_HEARTH_INSTANCE, seconds);
        class_638 level = class_310.method_1551().field_1687;
        if (level.method_8419() || level.method_8546()) {
            ((VolumeAudio)SOUND_MANAGER).timberHearth$setVolume(TIMBER_HEARTH_INSTANCE, 0.0f);
        }
    }

    public static void stop() {
        SOUND_MANAGER.method_4870(TIMBER_HEARTH_INSTANCE);
    }

    public static boolean in() {
        return flag;
    }

    public static boolean out() {
        return !flag;
    }

    public static boolean currentRain() {
        return currentSoundType == SoundType.RAIN;
    }

    public static boolean currentCave() {
        return currentSoundType == SoundType.CAVE;
    }

    public static boolean isTransitioning() {
        return (double)tick / (double)currentSoundType.getTotalTick() < 1.0;
    }

    public static void tick() {
        if (tick < currentSoundType.getTotalTick()) {
            ++tick;
        }
    }

    public static void fade(float partialTick) {
        float volume;
        if (tick >= currentSoundType.getTotalTick()) {
            return;
        }
        if (!SOUND_MANAGER.method_4877(TIMBER_HEARTH_INSTANCE)) {
            return;
        }
        double t = class_3532.method_15350((double)(((float)tick + partialTick) / (float)currentSoundType.getTotalTick()), (double)0.0, (double)1.0);
        currentVolume = volume = class_3532.method_15363((float)TimberHearthSoundControl.calculateVolume(t), (float)0.0f, (float)1.0f);
        if (volume == 1.0f || volume == 0.0f) {
            breakVolumePoint = -1.0f;
        }
        ((VolumeAudio)SOUND_MANAGER).timberHearth$setVolume(TIMBER_HEARTH_INSTANCE, volume);
    }

    private static float calculateVolume(double t) {
        return (float)(flag ? class_3532.method_16436((double)t, (double)(breakVolumePoint != -1.0f ? (double)breakVolumePoint : 1.0), (double)0.0) : class_3532.method_16436((double)t, (double)(breakVolumePoint != -1.0f ? (double)breakVolumePoint : 0.0), (double)1.0));
    }

    public static enum SoundType {
        RAIN(100),
        JOIN(40),
        DIMENSION(100),
        CAVE(60);

        private final int totalTick;

        private SoundType(int totalTick) {
            this.totalTick = totalTick;
        }

        public int getTotalTick() {
            return this.totalTick;
        }
    }
}

