#version 120

#define COSINUS_FREQUENCY 10.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0 41.0 42.0 43.0 44.0 45.0 46.0 47.0 48.0 49.0 50.0 51.0 52.0 53.0 54.0 55.0 56.0 57.0 58.0 59.0 60.0]
#define COSINUS_HEIGHT 10.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0]
#define COSINUS_DIRECTION 1 // [1 2 3 4]
#define COSINUS_SPEED 0 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69]
#define ONLY_IN_WATER 0 // [0 1]

uniform sampler2D gcolor;
uniform int worldTime;
uniform int isEyeInWater; 

varying vec2 texcoord;

void main() {
	vec2 texcoord1 = texcoord;
	float strength = 100 / COSINUS_HEIGHT;
	if(ONLY_IN_WATER == 0){
		if(COSINUS_DIRECTION == 1){
			texcoord1.y += cos(radians(texcoord.x*90*COSINUS_FREQUENCY-worldTime*COSINUS_SPEED))/strength;
		}
		if(COSINUS_DIRECTION == 2){
			texcoord1.y += sin(radians(texcoord.x*90*COSINUS_FREQUENCY+worldTime*COSINUS_SPEED))/strength;
		}
		if(COSINUS_DIRECTION == 3){
			texcoord1.x += sin(radians(texcoord.y*90*COSINUS_FREQUENCY+worldTime*COSINUS_SPEED))/strength;
		}
		if(COSINUS_DIRECTION == 4){
			texcoord1.x += sin(radians(texcoord.y*90*COSINUS_FREQUENCY-worldTime*COSINUS_SPEED))/strength;
		}
	}
	if(ONLY_IN_WATER == 1){
		if(isEyeInWater == 1){
			if(COSINUS_DIRECTION == 1){
				texcoord1.y += sin(radians(texcoord.x*90*COSINUS_FREQUENCY-worldTime*COSINUS_SPEED))/strength;
			}
			if(COSINUS_DIRECTION == 2){
				texcoord1.y += sin(radians(texcoord.x*90*COSINUS_FREQUENCY+worldTime*COSINUS_SPEED))/strength;
			}
			if(COSINUS_DIRECTION == 3){
				texcoord1.x += sin(radians(texcoord.y*90*COSINUS_FREQUENCY+worldTime*COSINUS_SPEED))/strength;
			}
			if(COSINUS_DIRECTION == 4){
				texcoord1.x += sin(radians(texcoord.y*90*COSINUS_FREQUENCY-worldTime*COSINUS_SPEED))/strength;
			}
		}
	}
	vec3 color = texture2D(gcolor, texcoord1).rgb;

/* DRAWBUFFERS:0 */
	gl_FragData[0] = vec4(color, 1.0); //gcolor
}