#version 150

#moj_import <minecraft:light.glsl>
#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:projection.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in vec2 UV1;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler2;

out float sphericalVertexDistance;
out float cylindricalVertexDistance;
out vec4 vertexColor;
out vec4 lightColor;
out vec2 texCoord0;
out vec2 texCoord1;
out vec2 texCoord2;

void main() {
    vec4 worldPos = vec4(Position, 1.0);
    gl_Position = ProjMat * ModelViewMat * worldPos;

    sphericalVertexDistance   = fog_spherical_distance(Position);
    cylindricalVertexDistance = fog_cylindrical_distance(Position);

    ivec2 lightUV   = UV2 / 16;
    vec4  blockLight = texelFetch(Sampler2, lightUV, 0);

    vec4 mixedLight = minecraft_mix_light(
        Light0_Direction,
        Light1_Direction,
        Normal,
        Color
    );

    vertexColor = mixedLight * blockLight;
    lightColor  = Color * blockLight;

    texCoord0 = UV0;
    texCoord1 = UV1;
    texCoord2 = UV2;
}
