local l = (bl and 1) or -1
local d = (bl and 1) or -0.8

global.pitchAngle = 0.0;
global.yawAngle = 0.0;
global.pitchAngleO = 0.0;
global.yawAngleO = 0.0;

local ptAngle = (mainHand and pitchAngle) or pitchAngleO
local ywAngle = (mainHand and yawAngle) or yawAngleO

local itemIds = {
	"minecraft:bell",
	"minecraft:iron_chain",
	"minecraft:copper_chain",
	"minecraft:exposed_copper_chain",
	"minecraft:weathered_copper_chain",
	"minecraft:oxidized_copper_chain"
}

local buckets = {
	"minecraft:bucket",
	"minecraft:water_bucket",
	"minecraft:cod_bucket",
	"minecraft:salmon_bucket",
	"minecraft:tropical_fish_bucket",
	"minecraft:pufferfish_bucket",
	"minecraft:axolotl_bucket",
	"minecraft:tadpole_bucket",
	"minecraft:lava_bucket",
	"minecraft:powder_snow_bucket",
	"minecraft:milk_bucket"
}

local physicsItems = {
	"minecraft:name_tag",
	"minecraft:iron_chain",
	"minecraft:copper_chain",
	"minecraft:exposed_copper_chain",
	"minecraft:weathered_copper_chain",
	"minecraft:oxidized_copper_chain"
}

for _, physicsItem in ipairs(physicsItems) do
	if I:isOf(item, Items:get(physicsItem)) then
		M:moveY(matrices, -0.2)
		M:rotateX(matrices, -70)
		M:rotateX(matrices, M:clamp(P:getPitch(player) / 2.5, -20, 90) + ptAngle + ywAngle * 0.5, 0, -0.13, 0)
		M:rotateZ(matrices, ywAngle * -0.7, -0.1 * l, 0, 0.1)
	end
end

for _, id in ipairs(itemIds) do
	renderAsBlock:put(id, false)
end

if I:isOf(item, Items:get("minecraft:bell")) then
	M:moveY(matrices, 0.6)
end

if I:isOf(item, Items:get("minecraft:trident")) then
	M:moveY(matrices, -0.4)
end

if I:isOf(item, Items:get("minecraft:shears")) then
	M:moveZ(matrices, -0.1)
	M:rotateZ(matrices, -45)
end

if I:isOf(item, Items:get("minecraft:totem_of_undying")) then
	M:moveX(matrices, -0.125 * l)
	M:moveY(matrices, 0.125)
	M:rotateX(matrices, -10)
	M:rotateY(matrices, 55 * l)
	I:setTranslate(item, true)

	particleManager:addParticle(
		particles,
		false,
		0.5 * l, 0.1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		2.5,
		Texture:of("minecraft", "textures/particle/orange_glow.png"),
		"ITEM",
		hand,
		"SPAWN",
		"TRANSLUCENT",
		0,
		200
	)
end

for i, id in pairs(buckets) do
	if I:isOf(item, Items:get(id)) then
		M:scale(matrices, 0.85, 0.85, 0.85)
		M:rotateX(matrices, -60)
		M:rotateY(matrices, -20 * d)
		M:rotateZ(matrices, -15 * l)
		M:moveX(matrices, -0.05 * l)
		M:moveZ(matrices, 0.2)
	end
end

if P:isUsingItem(player) and I:isOf(item, Items:get("minecraft:milk_bucket")) then
	M:scale(matrices, 1.15, 1.15, 1.15)
	M:rotateX(matrices, 0)
	M:rotateY(matrices, 20 * d)
	M:rotateZ(matrices, 15 * l)
end
