/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.client.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.client.particle.ShiftedParticle;

public class IceTrapParticle
extends ShiftedParticle {
    private final SpriteSet spriteProvider;
    private final List<TextureAtlasSprite> frames;

    protected IceTrapParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider, List<TextureAtlasSprite> frames) {
        super(world, x, y, z, velocityX, velocityY, velocityZ, spriteProvider);
        this.frames = frames;
        this.spriteProvider = spriteProvider;
        this.gravity = 0.225f;
        this.friction = 1.0f;
        this.yd = velocityY + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.quadSize = 0.4f;
        this.lifetime = 60;
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        super.tick();
        this.xd *= (double)0.95f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.95f;
        if (this.age < 10) {
            this.quadSize += 0.01f;
        }
        int frameRate = 5;
        int frame = this.age / 5;
        if (frame < 7) {
            this.setSprite(this.frames.get(frame));
        } else {
            int loopFrame = 7 + (frame - 7) % 5;
            this.setSprite(this.frames.get(loopFrame));
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class IceTrapParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public IceTrapParticleFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vx, double vy, double vz) {
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(12);
            for (int i = 0; i < 12; ++i) {
                sprites.add(this.spriteProvider.get(i, 12));
            }
            return new IceTrapParticle(world, x, y, z, vx, vy, vz, this.spriteProvider, sprites);
        }
    }
}

