/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.custom.spell_impacts;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellHandlers;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;

public class KnockbackRangeScaledSpellImpact
implements SpellHandlers.CustomImpact {
    public SpellHandlers.ImpactResult onSpellImpact(Holder<Spell> spell, SpellPower.Result powerResult, LivingEntity caster, Entity target, SpellHelper.ImpactContext context) {
        if (!caster.level().isClientSide && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            LivingEntity attacker = caster;
            float range = ((Spell)spell.value()).range;
            int poscasterX = attacker.blockPosition().getX();
            int poscasterZ = attacker.blockPosition().getZ();
            int posentityX = livingEntity.blockPosition().getX();
            int posentityZ = livingEntity.blockPosition().getZ();
            int distance_to_target = posentityX - poscasterX + (poscasterZ - posentityZ);
            float enchantment_power = 0.0f;
            float power_enchantment_value = 0.0f;
            float knockback_enchantment_value = 0.0f;
            Optional power_enchantment = attacker.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.PUNCH);
            Optional knockback_enchantment = attacker.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.KNOCKBACK);
            if (power_enchantment.isPresent()) {
                power_enchantment_value = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)power_enchantment.get()), (ItemStack)attacker.getMainHandItem());
            }
            if (knockback_enchantment.isPresent()) {
                knockback_enchantment_value = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)knockback_enchantment.get()), (ItemStack)attacker.getMainHandItem());
            }
            enchantment_power = power_enchantment_value + knockback_enchantment_value;
            float diff_calc = (range - (float)distance_to_target) / 5.0f;
            float knockback = 0.1f + diff_calc + enchantment_power;
            double d = attacker.getX() - livingEntity.getX();
            double e = attacker.getZ() - livingEntity.getZ();
            while (d * d + e * e < 1.0E-4) {
                d = (Math.random() - Math.random()) * 0.01;
                e = (Math.random() - Math.random()) * 0.01;
            }
            livingEntity.knockback((double)knockback, d, e);
        }
        return new SpellHandlers.ImpactResult(true, false);
    }
}

