/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.mixin;

import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.config.TweaksConfig;
import net.more_rpg_classes.effect.MRPGCEffects;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.spell_power.api.SpellPowerTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    long lastSpellvampireTick = 0L;
    @Unique
    private long lastLifestealTick = 0L;

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Inject(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")})
    private static void mrpgc_lib$createLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).add(MRPGCEntityAttributes.AIR_FUSE_MODIFIER).add(MRPGCEntityAttributes.ARCANE_FUSE_MODIFIER).add(MRPGCEntityAttributes.EARTH_FUSE_MODIFIER).add(MRPGCEntityAttributes.FIRE_FUSE_MODIFIER).add(MRPGCEntityAttributes.FROST_FUSE_MODIFIER).add(MRPGCEntityAttributes.HEALING_FUSE_MODIFIER).add(MRPGCEntityAttributes.WATER_FUSE_MODIFIER).add(MRPGCEntityAttributes.DAMAGE_REFLECT_MODIFIER).add(MRPGCEntityAttributes.LIFESTEAL_MODIFIER).add(MRPGCEntityAttributes.RAGE_MODIFIER).add(MRPGCEntityAttributes.SPELL_VAMPIRE);
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void damageReflect$damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!DamageTypes.THORNS.equals(source.type()) && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && source.isDirect()) {
            LivingEntity attackedEntity = (LivingEntity)this;
            Entity attacker = source.getEntity();
            AttributeInstance dmgReflect = attackedEntity.getAttribute(MRPGCEntityAttributes.DAMAGE_REFLECT_MODIFIER);
            int value1 = (int)dmgReflect.getValue();
            float reflectDamage = 0.0f;
            if (value1 != 100 && attacker instanceof LivingEntity) {
                float reflectMultiplier;
                LivingEntity livingAttacker = (LivingEntity)attacker;
                if (!attacker.level().isClientSide && (reflectDamage = amount * (reflectMultiplier = (float)(value1 - 100) / 100.0f)) != 0.0f) {
                    livingAttacker.invulnerableTime = 0;
                    livingAttacker.hurt(source.getEntity().damageSources().thorns((Entity)livingAttacker), reflectDamage);
                }
            }
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void spellVampire$damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity;
        if (source.is(SpellPowerTags.DamageTypes.ALL) && (entity = source.getEntity()) instanceof Player) {
            int value;
            Player playerEntity = (Player)entity;
            long currentTick = playerEntity.level().getGameTime();
            if (currentTick - this.lastSpellvampireTick < (long)((TweaksConfig)MRPGCMod.tweaksConfig.value).spellVampireCooldownTicks) {
                return;
            }
            float actualHealth = playerEntity.getHealth();
            float maxHealth = (float)playerEntity.getAttributeValue(Attributes.MAX_HEALTH);
            AttributeInstance spellVampire = playerEntity.getAttribute(MRPGCEntityAttributes.SPELL_VAMPIRE);
            if (spellVampire != null && (value = (int)spellVampire.getValue()) != 100 && actualHealth != maxHealth) {
                float multiplier = (float)(value -= 100) / 100.0f;
                float heal = amount * multiplier;
                playerEntity.heal(heal);
                this.lastSpellvampireTick = currentTick;
            }
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void lifesteal$damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity;
        if (source.is(DamageTypeTags.IS_PLAYER_ATTACK) && (entity = source.getEntity()) instanceof Player) {
            int value;
            Player playerEntity = (Player)entity;
            long currentTick = playerEntity.level().getGameTime();
            if (currentTick - this.lastLifestealTick < (long)((TweaksConfig)MRPGCMod.tweaksConfig.value).lifestealCooldownTicks) {
                return;
            }
            float actualHealth = playerEntity.getHealth();
            float maxHealth = (float)playerEntity.getAttributeValue(Attributes.MAX_HEALTH);
            AttributeInstance lifesteal = playerEntity.getAttribute(MRPGCEntityAttributes.LIFESTEAL_MODIFIER);
            if (lifesteal != null && (value = (int)lifesteal.getValue()) != 100 && actualHealth != maxHealth) {
                float multiplier = (float)(value -= 100) / 100.0f;
                float heal = amount * multiplier;
                playerEntity.heal(heal);
                this.lastLifestealTick = currentTick;
            }
        }
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    public void baseTickPowderSnowFrostedSolidEffect(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        entity.isInPowderSnow = entity.isInPowderSnow || this.hasEffect(MRPGCEffects.FROSTED.registryEntry);
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    public void baseTickPowderSnowFrozenSolidEffect(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        entity.isInPowderSnow = entity.isInPowderSnow || this.hasEffect(MRPGCEffects.FROZEN_SOLID.registryEntry);
    }
}

