/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.spell_engine.api.item.armor.Armor;

public abstract class SmithingRecipeGenerator
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final FabricDataOutput output;
    protected final String modId;
    private final List<RecipeData> recipes = new ArrayList<RecipeData>();

    public SmithingRecipeGenerator(FabricDataOutput output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    public abstract void generate();

    public void createSmithingTransformRecipe(String name, class_1792 base, Object template, Object addition, class_1792 result, String requiredMod) {
        this.createSmithingTransformRecipe(name, base, template, addition, result, new String[]{requiredMod});
    }

    public void createSmithingTransformRecipe(String name, class_1792 base, Object template, Object addition, class_1792 result, String[] requiredMods) {
        this.recipes.add(new RecipeData(name, base, template, addition, result, requiredMods, true));
    }

    public void createArmorSetUpgrade(String recipeBaseName, Armor.Set baseSet, Object template, Object addition, Armor.Set resultSet, String requiredMod) {
        String resultSetName = this.extractArmorSetName(resultSet);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_head", (class_1792)baseSet.head, template, addition, (class_1792)resultSet.head, requiredMod);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_chest", (class_1792)baseSet.chest, template, addition, (class_1792)resultSet.chest, requiredMod);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_legs", (class_1792)baseSet.legs, template, addition, (class_1792)resultSet.legs, requiredMod);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_feet", (class_1792)baseSet.feet, template, addition, (class_1792)resultSet.feet, requiredMod);
    }

    private String extractArmorSetName(Armor.Set armorSet) {
        class_2960 id = class_7923.field_41178.method_10221((Object)armorSet.head);
        String path = id.method_12832();
        if (path.endsWith("_head")) {
            return path.substring(0, path.length() - 5);
        }
        return path;
    }

    public void createArmorSetUpgrade(String recipeBaseName, Armor.Set baseSet, Object template, Object addition, Armor.Set resultSet, String[] requiredMods) {
        String resultSetName = this.extractArmorSetName(resultSet);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_head", (class_1792)baseSet.head, template, addition, (class_1792)resultSet.head, requiredMods);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_chest", (class_1792)baseSet.chest, template, addition, (class_1792)resultSet.chest, requiredMods);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_legs", (class_1792)baseSet.legs, template, addition, (class_1792)resultSet.legs, requiredMods);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_feet", (class_1792)baseSet.feet, template, addition, (class_1792)resultSet.feet, requiredMods);
    }

    public void createSimpleSmithingRecipe(String name, class_1792 base, Object template, Object addition, class_1792 result) {
        this.recipes.add(new RecipeData(name, base, template, addition, result, null, false));
    }

    public void createSimpleArmorSetUpgrade(String recipeBaseName, Armor.Set baseSet, Object template, Object addition, Armor.Set resultSet) {
        String resultSetName = this.extractArmorSetName(resultSet);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_head", (class_1792)baseSet.head, template, addition, (class_1792)resultSet.head);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_chest", (class_1792)baseSet.chest, template, addition, (class_1792)resultSet.chest);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_legs", (class_1792)baseSet.legs, template, addition, (class_1792)resultSet.legs);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_feet", (class_1792)baseSet.feet, template, addition, (class_1792)resultSet.feet);
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        this.generate();
        return CompletableFuture.allOf((CompletableFuture[])this.recipes.stream().map(recipeData -> {
            JsonObject recipe = this.buildRecipeJson((RecipeData)recipeData);
            Path path = this.output.method_45973(class_7784.class_7490.field_39367, "recipe").method_44107(class_2960.method_60655((String)this.modId, (String)recipeData.name));
            return class_2405.method_10320((class_7403)writer, (JsonElement)recipe, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    private JsonObject buildRecipeJson(RecipeData data) {
        JsonObject recipe = new JsonObject();
        if (data.withLoadConditions && data.requiredMods != null && data.requiredMods.length > 0) {
            JsonArray fabricLoadConditions = new JsonArray();
            JsonObject fabricCondition = new JsonObject();
            fabricCondition.addProperty("condition", "fabric:all_mods_loaded");
            JsonArray modValues = new JsonArray();
            for (String mod : data.requiredMods) {
                modValues.add(mod);
            }
            fabricCondition.add("values", (JsonElement)modValues);
            fabricLoadConditions.add((JsonElement)fabricCondition);
            recipe.add("fabric:load_conditions", (JsonElement)fabricLoadConditions);
            JsonArray neoforgeConditions = new JsonArray();
            if (data.requiredMods.length == 1) {
                JsonObject neoforgeCondition = new JsonObject();
                neoforgeCondition.addProperty("type", "neoforge:mod_loaded");
                neoforgeCondition.addProperty("modid", data.requiredMods[0]);
                neoforgeConditions.add((JsonElement)neoforgeCondition);
            } else {
                JsonObject andCondition = new JsonObject();
                andCondition.addProperty("type", "neoforge:and");
                JsonArray innerConditions = new JsonArray();
                for (String mod : data.requiredMods) {
                    JsonObject modCondition = new JsonObject();
                    modCondition.addProperty("type", "neoforge:mod_loaded");
                    modCondition.addProperty("modid", mod);
                    innerConditions.add((JsonElement)modCondition);
                }
                andCondition.add("conditions", (JsonElement)innerConditions);
                neoforgeConditions.add((JsonElement)andCondition);
            }
            recipe.add("neoforge:conditions", (JsonElement)neoforgeConditions);
        }
        recipe.addProperty("type", "minecraft:smithing_transform");
        JsonObject templateObj = new JsonObject();
        templateObj.addProperty("item", this.getItemId(data.template));
        recipe.add("template", (JsonElement)templateObj);
        JsonObject baseObj = new JsonObject();
        baseObj.addProperty("item", class_7923.field_41178.method_10221((Object)data.base).toString());
        recipe.add("base", (JsonElement)baseObj);
        JsonObject additionObj = new JsonObject();
        additionObj.addProperty("item", this.getItemId(data.addition));
        recipe.add("addition", (JsonElement)additionObj);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("id", class_7923.field_41178.method_10221((Object)data.result).toString());
        resultObj.addProperty("count", (Number)1);
        recipe.add("result", (JsonElement)resultObj);
        return recipe;
    }

    private String getItemId(Object itemOrId) {
        if (itemOrId instanceof class_2960) {
            class_2960 id = (class_2960)itemOrId;
            return id.toString();
        }
        if (itemOrId instanceof String) {
            String str = (String)itemOrId;
            return str;
        }
        if (itemOrId instanceof class_1792) {
            class_1792 item = (class_1792)itemOrId;
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            if (id.equals((Object)class_7923.field_41178.method_10221((Object)class_1802.field_8162))) {
                throw new IllegalStateException("Item resolved to minecraft:air - use Identifier instead of Item for cross-mod items!");
            }
            return id.toString();
        }
        throw new IllegalArgumentException("Template/Addition must be Item, Identifier, or String, got: " + String.valueOf(itemOrId.getClass()));
    }

    public String method_10321() {
        return "Smithing Recipes (" + this.modId + ")";
    }

    private record RecipeData(String name, class_1792 base, Object template, Object addition, class_1792 result, String[] requiredMods, boolean withLoadConditions) {
    }
}

