/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellSchool;

public class CustomMethods {
    public static void clearNegativeEffects(LivingEntity entity, boolean removeOne) {
        Collection effects = entity.getActiveEffects();
        ArrayList<Holder> toRemove = new ArrayList<Holder>();
        for (MobEffectInstance instance : effects) {
            Holder effectEntry = instance.getEffect();
            if (((MobEffect)effectEntry.value()).isBeneficial() || effectEntry.equals((Object)MobEffects.TRIAL_OMEN)) continue;
            toRemove.add(effectEntry);
        }
        if (removeOne) {
            if (!toRemove.isEmpty()) {
                entity.removeEffect((Holder)toRemove.get(0));
            }
        } else {
            for (Holder effect : toRemove) {
                entity.removeEffect(effect);
            }
        }
    }

    public static void stackFreezeStacks(LivingEntity e, int amount) {
        if (!e.canFreeze()) {
            return;
        }
        int cap = e.getTicksRequiredToFreeze() + 5;
        int newTicks = Math.min(cap, e.getTicksFrozen() + amount);
        e.setTicksFrozen(newTicks);
    }

    public static void freezeDamageTicks(LivingEntity e) {
        if (!e.canFreeze()) {
            return;
        }
        int cap = e.getTicksRequiredToFreeze() + 5;
        int newTicks = Math.min(cap, e.getTicksFrozen() + 3);
        e.setTicksFrozen(newTicks);
    }

    public static void spawnCloudEntity(ParticleOptions particleType, Entity owner, float radiusCloud, int durationSecondsCloud, float radiusGrowthCloud, Holder<MobEffect> statusEffect, int durationSecondsStatusEffect, int amplifierStatusEffect) {
        if (!owner.level().isClientSide) {
            List list = owner.level().getEntitiesOfClass(LivingEntity.class, owner.getBoundingBox().inflate(4.0, 2.0, 4.0));
            AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(owner.level(), owner.getX(), owner.getY(), owner.getZ());
            Entity entity = null;
            if (owner instanceof LivingEntity) {
                entity = owner;
            } else if (owner instanceof Projectile) {
                Projectile projectile = (Projectile)owner;
                owner = projectile.getOwner();
                areaEffectCloudEntity.setOwner((LivingEntity)owner);
            }
            if (entity instanceof LivingEntity) {
                areaEffectCloudEntity.setOwner((LivingEntity)entity);
            }
            areaEffectCloudEntity.setParticle(particleType);
            areaEffectCloudEntity.setRadius(radiusCloud);
            areaEffectCloudEntity.setDuration(durationSecondsCloud * 20);
            areaEffectCloudEntity.setRadiusPerTick((radiusGrowthCloud - areaEffectCloudEntity.getRadius()) / (float)areaEffectCloudEntity.getDuration());
            areaEffectCloudEntity.addEffect(new MobEffectInstance(statusEffect, durationSecondsStatusEffect * 20, amplifierStatusEffect, false, false, true));
            if (!list.isEmpty()) {
                for (LivingEntity livingEntity2 : list) {
                    double x = owner.distanceToSqr((Entity)livingEntity2);
                    if (!(x < 16.0)) continue;
                    areaEffectCloudEntity.setPos(livingEntity2.getX(), livingEntity2.getY(), livingEntity2.getZ());
                    break;
                }
            }
            owner.level().addFreshEntity((Entity)areaEffectCloudEntity);
        }
    }

    public static void applyStatusEffect(LivingEntity target, int effectAmplifier, int effectDurationSeconds, Holder<MobEffect> statusEffect, int maxStackAmplifier, boolean canStackAmplifier, boolean showIcon, boolean increaseDuration, int increaseEffectDurationSeconds) {
        if (target.hasEffect(statusEffect)) {
            int currentAmplifier = target.getEffect(statusEffect).getAmplifier();
            int currentDuration = target.getEffect(statusEffect).getDuration();
            int increaseAmp = 0;
            if (increaseDuration) {
                currentDuration += increaseEffectDurationSeconds * 20;
            }
            if (canStackAmplifier) {
                ++increaseAmp;
            }
            if (currentAmplifier < maxStackAmplifier) {
                target.addEffect(new MobEffectInstance(statusEffect, currentDuration, currentAmplifier + increaseAmp, false, false, showIcon));
            } else {
                target.addEffect(new MobEffectInstance(statusEffect, currentDuration, maxStackAmplifier, false, false, showIcon));
            }
        } else {
            target.addEffect(new MobEffectInstance(statusEffect, effectDurationSeconds * 20, effectAmplifier, false, false, showIcon));
        }
    }

    public static void spellSchoolDamageCalculation(SpellSchool spellSchool, float damageMultiplication, LivingEntity target, Player attacker) {
        float spellPower = (float)spellSchool.getValue(SpellSchool.Trait.POWER, new SpellSchool.QueryArgs((LivingEntity)attacker));
        float critChance = (float)spellSchool.getValue(SpellSchool.Trait.CRIT_CHANCE, new SpellSchool.QueryArgs((LivingEntity)attacker));
        float critDamage = (float)spellSchool.getValue(SpellSchool.Trait.CRIT_DAMAGE, new SpellSchool.QueryArgs((LivingEntity)attacker));
        float damageAmount = spellPower * damageMultiplication;
        float random = new Random().nextFloat(1.0f);
        if (random < critChance) {
            damageAmount *= critDamage;
        }
        target.hurt(SpellDamageSource.create((SpellSchool)spellSchool, (LivingEntity)attacker), damageAmount);
    }
}

