/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ConditionalItemLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "conditional_item";
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)"conditional_item");
    public static final MapCodec<ConditionalItemLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> ConditionalItemLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)Codec.STRING.fieldOf(NAME).forGetter(f -> f.conditionalItemId.toString())).apply((Applicative)instance, (conditions, id) -> new ConditionalItemLootFunction((List<LootItemCondition>)conditions, ResourceLocation.parse((String)id))));
    public static final LootItemFunctionType<ConditionalItemLootFunction> TYPE = new LootItemFunctionType(CODEC);
    private final ResourceLocation conditionalItemId;

    public ConditionalItemLootFunction(List<LootItemCondition> conditions, ResourceLocation conditionalItemId) {
        super(conditions);
        this.conditionalItemId = conditionalItemId;
    }

    public LootItemFunctionType<ConditionalItemLootFunction> getType() {
        return TYPE;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of();
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (BuiltInRegistries.ITEM.containsKey(this.conditionalItemId)) {
            Item item = (Item)BuiltInRegistries.ITEM.get(this.conditionalItemId);
            return new ItemStack((ItemLike)item);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(ResourceLocation conditionalItem) {
        return ConditionalItemLootFunction.simpleBuilder(conditions -> new ConditionalItemLootFunction((List<LootItemCondition>)conditions, conditionalItem));
    }
}

