/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util.loot;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.config.LootConfig;

public class LootInjector {
    public static void configure(HolderLookup.Provider registries, ResourceLocation id, LootTable.Builder tableBuilder) {
        LootConfig config = (LootConfig)MRPGCMod.lootConfig.value;
        String tableId = id.toString();
        LootConfig.Entry pool = config.entries.get(tableId);
        if (pool == null) {
            return;
        }
        float rolls = pool.rolls() > 0.0f ? pool.rolls() : 1.0f;
        LootPool.Builder lootPoolBuilder = LootPool.lootPool();
        double attempts = Math.ceil(rolls);
        double chance = (double)pool.rolls() / attempts;
        lootPoolBuilder.setRolls((NumberProvider)BinomialDistributionGenerator.binomial((int)((int)attempts), (float)((float)chance)));
        lootPoolBuilder.setBonusRolls((NumberProvider)ConstantValue.exactly((float)0.0f));
        for (LootConfig.Item entry : pool.items()) {
            Item item;
            String entryId = entry.itemId();
            int weight = entry.weight();
            int minAmount = entry.minAmount();
            int maxAmount = entry.maxAmount();
            if (entryId == null || entryId.isEmpty() || (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)entryId))) == null) continue;
            LootPoolSingletonContainer.Builder lootEntry = LootItem.lootTableItem((ItemLike)item).setWeight(weight);
            lootPoolBuilder.add((LootPoolEntryContainer.Builder)lootEntry);
            lootPoolBuilder.apply(SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minAmount, (float)maxAmount)).build());
        }
        tableBuilder.withPool(lootPoolBuilder);
    }

    private static NumberProvider numberProvider(float min, float max) {
        if (max <= min) {
            return ConstantValue.exactly((float)min);
        }
        return UniformGenerator.between((float)min, (float)max);
    }
}

