/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.more_rpg_classes.config.EffectsConfig;
import net.more_rpg_classes.config.TweaksConfig;
import net.more_rpg_classes.custom.CustomSpellEntityPredicate;
import net.more_rpg_classes.custom.CustomSpellImpacts;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.effect.MRPGCEffects;
import net.more_rpg_classes.item.MRPGCItems;
import net.more_rpg_classes.sounds.ModSounds;
import net.more_rpg_classes.util.loot.MRPGCLootTableEntityModifiers;
import net.more_rpg_classes.util.loot.SpecificSpellScrollPoolLootFunction;
import net.tiny_config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRPGCMod {
    public static final String MOD_ID = "more_rpg_classes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"more_rpg_classes");
    public static ConfigManager<EffectsConfig> effectsConfig = new ConfigManager("effects_v2", (Object)new EffectsConfig()).builder().setDirectory("more_rpg_classes").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks_v2", (Object)new TweaksConfig()).builder().setDirectory("more_rpg_classes").sanitize(true).build();

    public static void init() {
        effectsConfig.refresh();
        tweaksConfig.refresh();
        CustomSpellImpacts.registerCustomImpacts();
        MRPGCLootTableEntityModifiers.modifyLootEntityTables();
        MoreSpellSchools.initialize();
        CustomSpellImpacts.registerCustomImpacts();
        CustomSpellEntityPredicate.registerCustomPredicates();
    }

    public static void registerLootFunction() {
        Registry.register((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (ResourceLocation)SpecificSpellScrollPoolLootFunction.ID, SpecificSpellScrollPoolLootFunction.TYPE);
    }

    public static void registerSounds() {
        ModSounds.register();
    }

    public static void registerItems() {
        MRPGCItems.registerModItems();
    }

    public static void registerEffects() {
        MRPGCEffects.register();
        effectsConfig.save();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

