/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.custom.spell_impacts;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellHandlers;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;

public class RushForwardToTargetSpellImpact
implements SpellHandlers.CustomImpact {
    public SpellHandlers.ImpactResult onSpellImpact(Holder<Spell> spell, SpellPower.Result powerResult, LivingEntity caster, Entity target, SpellHelper.ImpactContext context) {
        if (!caster.level().isClientSide) {
            Vec3 lookVec = target.getViewVector(1.0f).normalize();
            Vec3 desiredPos = target.position().add(lookVec.scale(1.0));
            desiredPos = new Vec3(desiredPos.x, caster.getY(), desiredPos.z);
            Vec3 direction = desiredPos.subtract(caster.position());
            double distance = direction.length();
            if (distance > 0.001) {
                Vec3 velocity = direction.normalize().scale(distance);
                caster.setDeltaMovement(velocity);
                caster.hurtMarked = true;
                caster.hasImpulse = true;
            }
        }
        return new SpellHandlers.ImpactResult(true, false);
    }
}

