/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.custom;

import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.config.WeaknessConfig;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.util.tags.MRPGCEntityTags;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.weakness.ScopedWeakness;
import net.spell_engine.api.tags.SpellEngineEntityTags;
import net.spell_power.api.SpellSchool;

public class MoreSpellSchoolWeakness {
    public static List<ScopedWeakness> getWeaknesses(ResourceLocation schoolId) {
        if (schoolId == null) {
            return List.of();
        }
        WeaknessConfig config = (WeaknessConfig)MRPGCMod.weaknessConfig.value;
        if (config == null || config.school_weaknesses == null) {
            return List.of();
        }
        String key = schoolId.toString();
        return config.school_weaknesses.getOrDefault(key, List.of());
    }

    public static List<ScopedWeakness> getWeaknesses(@Nullable SpellSchool school) {
        if (school == null) {
            return List.of();
        }
        return MoreSpellSchoolWeakness.getWeaknesses(school.id);
    }

    public static WeaknessConfig createDefault() {
        WeaknessConfig config = new WeaknessConfig();
        Spell.Impact.TargetModifier waterWeakness = new Spell.Impact.TargetModifier();
        Spell.TargetCondition waterCondition = new Spell.TargetCondition();
        waterCondition.entity_type = "#" + String.valueOf(MRPGCEntityTags.WEAK_TO_WATER);
        waterWeakness.conditions = List.of(waterCondition);
        waterWeakness.modifier = new Spell.Impact.Modifier();
        waterWeakness.modifier.critical_chance_bonus = 1.0f;
        config.school_weaknesses.put(MoreSpellSchools.WATER.id.toString(), List.of(new ScopedWeakness(Spell.Impact.Action.Type.DAMAGE, waterWeakness)));
        Spell.Impact.TargetModifier waterResistance = new Spell.Impact.TargetModifier();
        Spell.TargetCondition waterConditionResistance = new Spell.TargetCondition();
        waterConditionResistance.entity_type = "#" + String.valueOf(MRPGCEntityTags.RESISTANT_TO_WATER);
        waterResistance.conditions = List.of(waterConditionResistance);
        waterResistance.modifier = new Spell.Impact.Modifier();
        waterResistance.modifier.power_multiplier = -0.3f;
        config.school_weaknesses.put(MoreSpellSchools.WATER.id.toString(), List.of(new ScopedWeakness(Spell.Impact.Action.Type.DAMAGE, waterResistance)));
        Spell.Impact.TargetModifier earthWeakness = new Spell.Impact.TargetModifier();
        Spell.TargetCondition earthCondition = new Spell.TargetCondition();
        earthCondition.entity_type = "#" + String.valueOf(MRPGCEntityTags.WEAK_TO_EARTH);
        earthWeakness.conditions = List.of(earthCondition);
        earthWeakness.modifier = new Spell.Impact.Modifier();
        earthWeakness.modifier.critical_chance_bonus = 0.3f;
        config.school_weaknesses.put(MoreSpellSchools.EARTH.id.toString(), List.of(new ScopedWeakness(Spell.Impact.Action.Type.DAMAGE, earthWeakness)));
        Spell.Impact.TargetModifier fireWeakness = new Spell.Impact.TargetModifier();
        Spell.TargetCondition fireCondition = new Spell.TargetCondition();
        fireCondition.entity_type = "#" + String.valueOf(SpellEngineEntityTags.Vulnerability.WEAK_TO_FIRE.id());
        fireWeakness.conditions = List.of(fireCondition);
        fireWeakness.modifier = new Spell.Impact.Modifier();
        fireWeakness.modifier.critical_chance_bonus = 0.3f;
        config.school_weaknesses.put(MoreSpellSchools.FIRE_RANGED.id.toString(), List.of(new ScopedWeakness(Spell.Impact.Action.Type.DAMAGE, fireWeakness)));
        Spell.Impact.TargetModifier frostWeakness = new Spell.Impact.TargetModifier();
        Spell.TargetCondition frostWeaknessCondition = new Spell.TargetCondition();
        frostWeaknessCondition.entity_type = "#" + String.valueOf(SpellEngineEntityTags.Vulnerability.WEAK_TO_FROST.id());
        frostWeakness.conditions = List.of(frostWeaknessCondition);
        frostWeakness.modifier = new Spell.Impact.Modifier();
        frostWeakness.modifier.power_multiplier = 0.3f;
        Spell.Impact.TargetModifier frostResistance = new Spell.Impact.TargetModifier();
        Spell.TargetCondition frostResistanceCondition = new Spell.TargetCondition();
        frostResistanceCondition.entity_type = "#" + String.valueOf(SpellEngineEntityTags.Vulnerability.RESISTANT_TO_FROST.id());
        frostResistance.conditions = List.of(frostResistanceCondition);
        frostResistance.modifier = new Spell.Impact.Modifier();
        frostResistance.modifier.power_multiplier = -0.3f;
        config.school_weaknesses.put(MoreSpellSchools.FROST_RANGED.id.toString(), List.of(new ScopedWeakness(null, frostWeakness), new ScopedWeakness(null, frostResistance)));
        return config;
    }
}

