/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.datagen;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.more_rpg_classes.compat.armory_rpgs.SmithingIngredients;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class MrpgDatagen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(LangGenerator::new);
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        }

        public void generateItemModels(ItemModelGenerators itemModelGenerator) {
            SmithingIngredients.ENTRIES.forEach(entry -> itemModelGenerator.generateFlatItem((Item)entry.item().get(), ModelTemplates.FLAT_ITEM));
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(HolderLookup.Provider wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            SmithingIngredients.ENTRIES.forEach(entry -> {
                translationBuilder.add(entry.id().toLanguageKey("item"), entry.translations().itemName());
                translationBuilder.add(entry.appliesToTranslationKey(), entry.appliesToClassesTranslation());
            });
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            TagKey tierTag = RPGSeriesItemTags.LootTiers.get((int)5, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS);
            SmithingIngredients.ENTRIES.forEach(entry -> {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tierTag);
                tag.addOptional(entry.id());
            });
        }
    }
}

