/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.spell_engine.api.item.armor.Armor;

public abstract class SmithingRecipeGenerator
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final FabricDataOutput output;
    protected final String modId;
    private final List<RecipeData> recipes = new ArrayList<RecipeData>();

    public SmithingRecipeGenerator(FabricDataOutput output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    public abstract void generate();

    public void createSmithingTransformRecipe(String name, Item base, Object template, Object addition, Item result, String requiredMod) {
        this.createSmithingTransformRecipe(name, base, template, addition, result, new String[]{requiredMod});
    }

    public void createSmithingTransformRecipe(String name, Item base, Object template, Object addition, Item result, String[] requiredMods) {
        this.recipes.add(new RecipeData(name, base, template, addition, result, requiredMods, true));
    }

    public void createArmorSetUpgrade(String recipeBaseName, Armor.Set baseSet, Object template, Object addition, Armor.Set resultSet, String requiredMod) {
        String resultSetName = this.extractArmorSetName(resultSet);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_head", (Item)baseSet.head, template, addition, (Item)resultSet.head, requiredMod);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_chest", (Item)baseSet.chest, template, addition, (Item)resultSet.chest, requiredMod);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_legs", (Item)baseSet.legs, template, addition, (Item)resultSet.legs, requiredMod);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_feet", (Item)baseSet.feet, template, addition, (Item)resultSet.feet, requiredMod);
    }

    private String extractArmorSetName(Armor.Set armorSet) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)armorSet.head);
        String path = id.getPath();
        if (path.endsWith("_head")) {
            return path.substring(0, path.length() - 5);
        }
        return path;
    }

    public void createArmorSetUpgrade(String recipeBaseName, Armor.Set baseSet, Object template, Object addition, Armor.Set resultSet, String[] requiredMods) {
        String resultSetName = this.extractArmorSetName(resultSet);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_head", (Item)baseSet.head, template, addition, (Item)resultSet.head, requiredMods);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_chest", (Item)baseSet.chest, template, addition, (Item)resultSet.chest, requiredMods);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_legs", (Item)baseSet.legs, template, addition, (Item)resultSet.legs, requiredMods);
        this.createSmithingTransformRecipe(recipeBaseName + "_" + resultSetName + "_feet", (Item)baseSet.feet, template, addition, (Item)resultSet.feet, requiredMods);
    }

    public void createSimpleSmithingRecipe(String name, Item base, Object template, Object addition, Item result) {
        this.recipes.add(new RecipeData(name, base, template, addition, result, null, false));
    }

    public void createSimpleArmorSetUpgrade(String recipeBaseName, Armor.Set baseSet, Object template, Object addition, Armor.Set resultSet) {
        String resultSetName = this.extractArmorSetName(resultSet);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_head", (Item)baseSet.head, template, addition, (Item)resultSet.head);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_chest", (Item)baseSet.chest, template, addition, (Item)resultSet.chest);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_legs", (Item)baseSet.legs, template, addition, (Item)resultSet.legs);
        this.createSimpleSmithingRecipe(recipeBaseName + "_" + resultSetName + "_feet", (Item)baseSet.feet, template, addition, (Item)resultSet.feet);
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        this.generate();
        return CompletableFuture.allOf((CompletableFuture[])this.recipes.stream().map(recipeData -> {
            JsonObject recipe = this.buildRecipeJson((RecipeData)recipeData);
            Path path = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "recipe").json(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)recipeData.name));
            return DataProvider.saveStable((CachedOutput)writer, (JsonElement)recipe, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    private JsonObject buildRecipeJson(RecipeData data) {
        JsonObject recipe = new JsonObject();
        if (data.withLoadConditions && data.requiredMods != null && data.requiredMods.length > 0) {
            JsonArray fabricLoadConditions = new JsonArray();
            JsonObject fabricCondition = new JsonObject();
            fabricCondition.addProperty("condition", "fabric:all_mods_loaded");
            JsonArray modValues = new JsonArray();
            for (String mod : data.requiredMods) {
                modValues.add(mod);
            }
            fabricCondition.add("values", (JsonElement)modValues);
            fabricLoadConditions.add((JsonElement)fabricCondition);
            recipe.add("fabric:load_conditions", (JsonElement)fabricLoadConditions);
            JsonArray neoforgeConditions = new JsonArray();
            if (data.requiredMods.length == 1) {
                JsonObject neoforgeCondition = new JsonObject();
                neoforgeCondition.addProperty("type", "neoforge:mod_loaded");
                neoforgeCondition.addProperty("modid", data.requiredMods[0]);
                neoforgeConditions.add((JsonElement)neoforgeCondition);
            } else {
                JsonObject andCondition = new JsonObject();
                andCondition.addProperty("type", "neoforge:and");
                JsonArray innerConditions = new JsonArray();
                for (String mod : data.requiredMods) {
                    JsonObject modCondition = new JsonObject();
                    modCondition.addProperty("type", "neoforge:mod_loaded");
                    modCondition.addProperty("modid", mod);
                    innerConditions.add((JsonElement)modCondition);
                }
                andCondition.add("conditions", (JsonElement)innerConditions);
                neoforgeConditions.add((JsonElement)andCondition);
            }
            recipe.add("neoforge:conditions", (JsonElement)neoforgeConditions);
        }
        recipe.addProperty("type", "minecraft:smithing_transform");
        JsonObject templateObj = new JsonObject();
        templateObj.addProperty("item", this.getItemId(data.template));
        recipe.add("template", (JsonElement)templateObj);
        JsonObject baseObj = new JsonObject();
        baseObj.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)data.base).toString());
        recipe.add("base", (JsonElement)baseObj);
        JsonObject additionObj = new JsonObject();
        additionObj.addProperty("item", this.getItemId(data.addition));
        recipe.add("addition", (JsonElement)additionObj);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("id", BuiltInRegistries.ITEM.getKey((Object)data.result).toString());
        resultObj.addProperty("count", (Number)1);
        recipe.add("result", (JsonElement)resultObj);
        return recipe;
    }

    private String getItemId(Object itemOrId) {
        if (itemOrId instanceof ResourceLocation) {
            ResourceLocation id = (ResourceLocation)itemOrId;
            return id.toString();
        }
        if (itemOrId instanceof String) {
            String str = (String)itemOrId;
            return str;
        }
        if (itemOrId instanceof Item) {
            Item item = (Item)itemOrId;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            if (id.equals((Object)BuiltInRegistries.ITEM.getKey((Object)Items.AIR))) {
                throw new IllegalStateException("Item resolved to minecraft:air - use Identifier instead of Item for cross-mod items!");
            }
            return id.toString();
        }
        throw new IllegalArgumentException("Template/Addition must be Item, Identifier, or String, got: " + String.valueOf(itemOrId.getClass()));
    }

    public String getName() {
        return "Smithing Recipes (" + this.modId + ")";
    }

    private record RecipeData(String name, Item base, Object template, Object addition, Item result, String[] requiredMods, boolean withLoadConditions) {
    }
}

