/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.effect;

import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.more_rpg_classes.effect.MRPGCEffects;
import net.spell_power.api.statuseffects.SpellVulnerabilityStatusEffect;

public class FrozenSolidEffect
extends SpellVulnerabilityStatusEffect {
    public FrozenSolidEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        super.onEffectStarted(livingEntity, amplifier);
        EntityType type = livingEntity.getType();
        if (type.is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES)) {
            livingEntity.removeEffect(MRPGCEffects.FROZEN_SOLID.registryEntry);
        }
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int pAmplifier) {
        if (livingEntity.isOnFire() || livingEntity.isInLava()) {
            return livingEntity.removeEffect(MRPGCEffects.FROZEN_SOLID.registryEntry);
        }
        super.applyEffectTick(livingEntity, pAmplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

