/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.effect;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.config.EffectsConfig;
import net.more_rpg_classes.effect.BleedingEffect;
import net.more_rpg_classes.effect.CustomStatusEffect;
import net.more_rpg_classes.effect.FrostedEffect;
import net.more_rpg_classes.effect.FrozenSolidEffect;
import net.more_rpg_classes.effect.MoltenArmorEffect;
import net.more_rpg_classes.effect.SoakedEffect;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.RemoveOnHit;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchools;

public class MRPGCEffects {
    private static final ArrayList<Entry> entries = new ArrayList();
    public static final Entry MOLTEN_ARMOR = new Entry("molten_armor", new MoltenArmorEffect(MobEffectCategory.HARMFUL, 14503424));
    public static final Entry FROZEN_SOLID = new Entry("frozen_solid", (MobEffect)new FrozenSolidEffect(MobEffectCategory.HARMFUL, 3927807).setVulnerability(SpellSchools.FROST, new SpellPower.Vulnerability(0.0f, 0.1f, 0.2f)));
    public static final Entry COLLECTED_SOUL = new Entry("collected_soul", new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 121295));
    public static final Entry GRIEVOUS_WOUNDS = new Entry("grievous_wounds", new CustomStatusEffect(MobEffectCategory.HARMFUL, 121295));
    public static final Entry FROSTED = new Entry("frosted", new FrostedEffect(MobEffectCategory.HARMFUL, 3927807));
    public static final Entry BLEEDING = new Entry("bleeding", new BleedingEffect(MobEffectCategory.HARMFUL, 14503424));
    public static final Entry FEAR = new Entry("fear", new CustomStatusEffect(MobEffectCategory.HARMFUL, 121295));
    public static final Entry STAGGER = new Entry("stagger", new CustomStatusEffect(MobEffectCategory.HARMFUL, 0xB3B3B3));
    public static final Entry SOAKED = new Entry("soaked", (MobEffect)new SoakedEffect(MobEffectCategory.HARMFUL, 121295).setVulnerability(SpellSchools.LIGHTNING, new SpellPower.Vulnerability(0.15f, 0.1f, 0.0f)).setVulnerability(SpellSchools.FROST, new SpellPower.Vulnerability(0.15f, 0.0f, 0.3f)));

    public static void register() {
        MRPGCEffects.MOLTEN_ARMOR.effect.addAttributeModifier(Attributes.ARMOR, MOLTEN_ARMOR.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).molten_armor_armor_reduction_per_stack, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.ARMOR_TOUGHNESS, MOLTEN_ARMOR.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).molten_armor_armor_toughness_reduction_per_stack, AttributeModifier.Operation.ADD_VALUE);
        MRPGCEffects.FEAR.effect.addAttributeModifier(Attributes.ATTACK_DAMAGE, FEAR.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).fear_attack_damage_reduction, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        MRPGCEffects.COLLECTED_SOUL.effect.addAttributeModifier(SpellSchools.SOUL.attributeEntry, COLLECTED_SOUL.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).collected_soul_soul_power_per_stack, AttributeModifier.Operation.ADD_VALUE);
        MRPGCEffects.FROSTED.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, FROSTED.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).frosted_decreased_movement_speed_per_stack, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        MRPGCEffects.FROZEN_SOLID.effect.addAttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.entry, FROZEN_SOLID.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).frozen_solid_increased_damage_taken, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        MRPGCEffects.GRIEVOUS_WOUNDS.effect.addAttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.entry, GRIEVOUS_WOUNDS.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).grievous_wounds_increased_damage_taken, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(SpellEngineAttributes.HEALING_TAKEN.entry, GRIEVOUS_WOUNDS.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).grievous_wounds_healing_taken, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        MRPGCEffects.STAGGER.effect.addAttributeModifier(Attributes.ATTACK_DAMAGE, STAGGER.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).stagger_attack_armor_speed_decrease, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.ARMOR, STAGGER.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).stagger_attack_armor_speed_decrease, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.MOVEMENT_SPEED, STAGGER.modifierId(), (double)((EffectsConfig)MRPGCMod.effectsConfig.value).stagger_attack_armor_speed_decrease, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        for (Entry entry : entries) {
            Synchronized.configure((MobEffect)entry.effect, (boolean)true);
        }
        RemoveOnHit.configure((MobEffect)MRPGCEffects.FROZEN_SOLID.effect, (RemoveOnHit.Trigger)RemoveOnHit.Trigger.DIRECT_HIT, (int)1, (float)1.0f);
        ActionImpairing.configure((MobEffect)MRPGCEffects.FROZEN_SOLID.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        ActionImpairing.configure((MobEffect)MRPGCEffects.FEAR.effect, (EntityActionsAllowed)EntityActionsAllowed.INCAPACITATE);
        ActionImpairing.configure((MobEffect)MRPGCEffects.STAGGER.effect, (EntityActionsAllowed)EntityActionsAllowed.INCAPACITATE);
        for (Entry entry : entries) {
            entry.register();
        }
    }

    public static class Entry {
        public final ResourceLocation id;
        public final MobEffect effect;
        public Holder<MobEffect> registryEntry;

        public Entry(String name, MobEffect effect) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)name);
            this.effect = effect;
            entries.add(this);
        }

        public void register() {
            this.registryEntry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)this.id, (Object)this.effect);
        }

        public ResourceLocation modifierId() {
            return ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)("effect." + this.id.getPath()));
        }
    }
}

