/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.internals.target.EntityRelation;
import net.spell_engine.internals.target.EntityRelations;

public class FriendlyLightningEntity
extends Entity {
    private int ambientTick;
    private int remainingActions = 2;
    private LivingEntity owner;
    public long seed;

    public FriendlyLightningEntity(EntityType<? extends FriendlyLightningEntity> entityType, Level world) {
        super(entityType, world);
        this.owner = null;
        this.noCulling = true;
        this.ambientTick = 2;
        this.seed = this.random.nextLong();
    }

    public FriendlyLightningEntity(EntityType<? extends FriendlyLightningEntity> entityType, Level world, double x, double y, double z, LivingEntity owner) {
        super(entityType, world);
        this.owner = owner;
        this.noCulling = true;
        this.ambientTick = 2;
        this.seed = this.random.nextLong();
        this.moveTo(x, y, z, 0.0f, 0.0f);
    }

    public SoundSource getSoundSource() {
        return SoundSource.WEATHER;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.ambientTick == 2) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10000.0f, 0.8f + this.random.nextFloat() * 0.2f, false);
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 2.0f, 0.5f + this.random.nextFloat() * 0.2f, false);
            } else {
                Difficulty difficulty = this.level().getDifficulty();
                if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                    this.spawnFire();
                }
                this.damageEntities();
            }
        }
        --this.ambientTick;
        if (this.ambientTick < 0) {
            if (this.remainingActions == 0) {
                this.discard();
            } else if (this.ambientTick < -this.random.nextInt(10)) {
                --this.remainingActions;
                this.ambientTick = 1;
                if (!this.level().isClientSide) {
                    this.damageEntities();
                }
            }
        }
        if (this.ambientTick >= 0 && !this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.setSkyFlashTime(2);
        }
    }

    private void damageEntities() {
        if (this.level().isClientSide || !(this.level() instanceof ServerLevel)) {
            return;
        }
        float damageAmount = 5.0f;
        double radius = 3.0;
        List entities = this.level().getEntities((Entity)this, new AABB(this.getX() - radius, this.getY() - radius, this.getZ() - radius, this.getX() + radius, this.getY() + 6.0 + radius, this.getZ() + radius));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.owner != null && entity.equals((Object)this.owner) || this.owner != null && this.isFriendly(this.owner, livingEntity)) continue;
            entity.hurt(this.damageSources().lightningBolt(), damageAmount);
        }
    }

    private boolean isFriendly(LivingEntity owner, LivingEntity target) {
        if (owner == null || target == null) {
            return false;
        }
        try {
            EntityRelation relation = EntityRelations.getRelation((LivingEntity)owner, (Entity)target);
            return relation == EntityRelation.ALLY;
        }
        catch (Exception e) {
            return !EntityRelations.allowedToHurt((Entity)owner, (Entity)target);
        }
    }

    private void spawnFire() {
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double renderDistance = 64.0 * FriendlyLightningEntity.getViewScale();
        return distance < renderDistance * renderDistance;
    }

    public static FriendlyLightningEntity spawn(ServerLevel world, Vec3 pos, LivingEntity owner, EntityType<FriendlyLightningEntity> entityType) {
        FriendlyLightningEntity lightning = new FriendlyLightningEntity(entityType, (Level)world, pos.x, pos.y, pos.z, owner);
        world.addFreshEntity((Entity)lightning);
        return lightning;
    }

    public static FriendlyLightningEntity spawnAtBlock(ServerLevel world, BlockPos pos, LivingEntity owner, EntityType<FriendlyLightningEntity> entityType) {
        return FriendlyLightningEntity.spawn(world, Vec3.atBottomCenterOf((Vec3i)pos), owner, entityType);
    }
}

