/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.entity.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.more_rpg_classes.MRPGCMod;
import net.more_rpg_classes.entity.ISpellCasterEntity;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class CastSpellGoal
extends Goal {
    private final ISpellCasterEntity caster;
    private final ResourceLocation spellId;
    private final List<CastSpellGoal> otherSpellGoals;
    private int spellCooldown = 0;
    private int castingTime = 0;
    private int totalCastTime = 0;
    private boolean isChanneling = false;
    private int channelingInterval = 0;
    private int nextChannelingImpact = 0;

    public CastSpellGoal(ISpellCasterEntity caster, ResourceLocation spellId) {
        this(caster, spellId, null);
    }

    public CastSpellGoal(ISpellCasterEntity caster, ResourceLocation spellId, List<CastSpellGoal> otherSpellGoals) {
        this.caster = caster;
        this.spellId = spellId;
        this.otherSpellGoals = otherSpellGoals;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Mob entity = this.caster.asMobEntity();
        LivingEntity target = entity.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (this.caster.isSpellcasting()) {
            return false;
        }
        if (this.spellCooldown > 0) {
            return false;
        }
        if (this.otherSpellGoals != null) {
            for (CastSpellGoal otherGoal : this.otherSpellGoals) {
                if (otherGoal == this || !otherGoal.isActive()) continue;
                return false;
            }
        }
        double range = this.caster.getSpellRange(this.spellId);
        double distance = Math.sqrt(entity.distanceToSqr((Entity)target));
        return distance <= range;
    }

    public boolean canContinueToUse() {
        Mob entity = this.caster.asMobEntity();
        LivingEntity target = entity.getTarget();
        return target != null && target.isAlive() && this.castingTime > 0;
    }

    public void start() {
        Holder spellEntry;
        this.totalCastTime = this.castingTime = this.caster.getCastTime(this.spellId);
        ISpellCasterEntity.SpellType spellType = this.caster.getSpellType(this.spellId);
        ISpellCasterEntity.CastingType castingType = this.caster.getCastingType(this.spellId);
        if (castingType == ISpellCasterEntity.CastingType.CHANNELING) {
            int channelTicks;
            this.isChanneling = true;
            spellEntry = SpellRegistry.from((Level)this.caster.asMobEntity().level()).getHolder(this.spellId).orElse(null);
            this.channelingInterval = spellEntry != null && ((Spell)spellEntry.value()).active.cast != null ? ((channelTicks = ((Spell)spellEntry.value()).active.cast.channel_ticks) > 0 ? channelTicks : 20) : 20;
            this.nextChannelingImpact = 0;
        } else {
            this.isChanneling = false;
        }
        this.caster.startSpellCast(this.castingTime);
        spellEntry = SpellRegistry.from((Level)this.caster.asMobEntity().level()).getHolder(this.spellId).orElse(null);
        if (spellEntry != null && ((Spell)spellEntry.value()).active.cast != null) {
            ParticleHelper.sendBatches((Entity)this.caster.asMobEntity(), (ParticleBatch[])((Spell)spellEntry.value()).active.cast.particles);
        }
    }

    public void tick() {
        Mob entity = this.caster.asMobEntity();
        LivingEntity target = entity.getTarget();
        if (target != null) {
            entity.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        --this.castingTime;
        if (this.castingTime % 5 == 0) {
            // empty if block
        }
        if (this.isChanneling) {
            Holder spellEntry = SpellRegistry.from((Level)entity.level()).getHolder(this.spellId).orElse(null);
            if (spellEntry != null && ((Spell)spellEntry.value()).active.cast != null) {
                ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])((Spell)spellEntry.value()).active.cast.particles);
            }
            --this.nextChannelingImpact;
            if (this.nextChannelingImpact <= 0) {
                this.faceTarget(target);
                this.castSpell();
                this.nextChannelingImpact = this.channelingInterval;
            }
        } else if (this.castingTime == this.totalCastTime / 2) {
            this.faceTarget(target);
            this.castSpell();
        }
    }

    private void faceTarget(LivingEntity target) {
        Mob entity = this.caster.asMobEntity();
        if (target != null) {
            double deltaX = target.getX() - entity.getX();
            double deltaY = target.getEyeY() - entity.getEyeY();
            double deltaZ = target.getZ() - entity.getZ();
            double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            float targetYaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
            float targetPitch = (float)(-(Math.atan2(deltaY, horizontalDistance) * 57.29577951308232));
            entity.setYRot(targetYaw);
            entity.setXRot(targetPitch);
            entity.yHeadRot = targetYaw;
            entity.yBodyRot = targetYaw;
        }
    }

    public void stop() {
        this.caster.stopSpellCast();
        this.spellCooldown = this.caster.getSpellCooldown(this.spellId);
        this.castingTime = 0;
        this.totalCastTime = 0;
        this.isChanneling = false;
        this.channelingInterval = 0;
        this.nextChannelingImpact = 0;
    }

    private void castSpell() {
        Mob entity = this.caster.asMobEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        LivingEntity target = entity.getTarget();
        if (target == null) {
            return;
        }
        ISpellCasterEntity.SpellType spellType = this.caster.getSpellType(this.spellId);
        Holder spellEntry = SpellRegistry.from((Level)entity.level()).getHolder(this.spellId).orElse(null);
        if (spellEntry == null) {
            MRPGCMod.LOGGER.warn("Spell not found: " + String.valueOf(this.spellId));
            return;
        }
        try {
            switch (spellType) {
                case METEOR: {
                    this.castMeteorSpell(target, (Holder<Spell>)spellEntry);
                    break;
                }
                case PROJECTILE: {
                    this.castProjectileSpell(target, (Holder<Spell>)spellEntry);
                    break;
                }
                case CLOUD: {
                    this.castCloudSpell(target, (Holder<Spell>)spellEntry);
                    break;
                }
                case DIRECTIMPACT: {
                    this.castDirectImpactSpell(target, (Holder<Spell>)spellEntry);
                    break;
                }
                case AREAIMPACT: {
                    this.castAreaImpactSpell(target, (Holder<Spell>)spellEntry);
                }
            }
        }
        catch (Exception e) {
            MRPGCMod.LOGGER.error("Failed to cast spell " + String.valueOf(this.spellId) + " for spell caster", (Throwable)e);
        }
    }

    private void castMeteorSpell(LivingEntity target, Holder<Spell> spellEntry) {
        Mob entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.value();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (LivingEntity)entity);
        ISpellCasterEntity.PlacementTarget placementTarget = this.caster.getPlacementTarget(this.spellId);
        Vec3 position = placementTarget == ISpellCasterEntity.PlacementTarget.TARGET ? target.position() : entity.position();
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)entity)).position(position).target(SpellTarget.FocusMode.AREA);
        ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])spell.release.particles);
        try {
            SpellHelper.fallProjectile((Level)entity.level(), (LivingEntity)entity, (Entity)target, (Vec3)position, spellEntry, (SpellHelper.ImpactContext)context);
        }
        catch (Exception e) {
            SpellHelper.performImpacts((Level)entity.level(), (LivingEntity)entity, (Entity)target, (Entity)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
        }
    }

    private void castProjectileSpell(LivingEntity target, Holder<Spell> spellEntry) {
        Mob entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.value();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (LivingEntity)entity);
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(power).position(entity.getEyePosition()).target(SpellHelper.focusMode((Spell)spell));
        ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])spell.release.particles);
        try {
            SpellHelper.shootProjectile((Level)entity.level(), (LivingEntity)entity, (Entity)target, spellEntry, (SpellHelper.ImpactContext)context, (int)0);
        }
        catch (Exception e) {
            SpellHelper.performImpacts((Level)entity.level(), (LivingEntity)entity, (Entity)target, (Entity)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
        }
    }

    private void castDirectImpactSpell(LivingEntity target, Holder<Spell> spellEntry) {
        Mob entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.value();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (LivingEntity)entity);
        ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])spell.active.cast.particles);
        ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])spell.release.particles);
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(power).position(entity.getEyePosition()).target(SpellHelper.focusMode((Spell)spell));
        SpellHelper.performImpacts((Level)entity.level(), (LivingEntity)entity, (Entity)target, (Entity)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
    }

    private void castAreaImpactSpell(LivingEntity target, Holder<Spell> spellEntry) {
        Mob entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.value();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (LivingEntity)entity);
        if (!entity.level().isClientSide() && target != null) {
            ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])spell.release.particles);
            ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])spell.release.particles_scaled_with_ranged);
            for (Entity targetEntity : TargetHelper.targetsFromArea((Entity)entity, (float)spell.range, (Spell.Target.Area)spell.target.area, e -> e != entity)) {
                SpellHelper.performImpacts((Level)entity.level(), (LivingEntity)entity, (Entity)targetEntity, (Entity)entity, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)new SpellHelper.ImpactContext().power(power).position(entity.position()));
                ParticleHelper.sendBatches((Entity)targetEntity, (ParticleBatch[])((Spell.Impact)spell.impacts.get((int)0)).particles);
            }
        }
    }

    private void castCloudSpell(LivingEntity target, Holder<Spell> spellEntry) {
        Mob entity = this.caster.asMobEntity();
        Spell spell = (Spell)spellEntry.value();
        SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)this.caster.getSpellSchool(), (LivingEntity)entity);
        ISpellCasterEntity.PlacementTarget placementTarget = this.caster.getPlacementTarget(this.spellId);
        Vec3 position = placementTarget == ISpellCasterEntity.PlacementTarget.TARGET ? target.position() : entity.position();
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(power).position(entity.getEyePosition()).target(SpellTarget.FocusMode.AREA);
        ParticleHelper.sendBatches((Entity)entity, (ParticleBatch[])spell.release.particles);
        SpellHelper.placeCloud((Level)entity.level(), (LivingEntity)entity, (Entity)target, (Vec3)position, spellEntry, (SpellHelper.ImpactContext)context);
    }

    public boolean isActive() {
        return this.castingTime > 0;
    }

    public void updateCooldown() {
        if (this.spellCooldown > 0) {
            --this.spellCooldown;
        }
    }
}

