/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void mrpgc$boostRageDamageOnAttack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        if (target instanceof LivingEntity) {
            AttributeInstance rage;
            LivingEntity livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (rage = player.getAttribute(MRPGCEntityAttributes.RAGE_MODIFIER)) != null) {
                float rageValue = (float)(rage.getValue() - 100.0) / 100.0f;
                float health = player.getHealth();
                float maxHealth = (float)player.getAttributeValue(Attributes.MAX_HEALTH);
                float missing = (maxHealth - health) / maxHealth;
                if (rageValue != 0.0f && health < maxHealth) {
                    float baseDamage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
                    float extraDamage = Math.max(0.1f, baseDamage * rageValue * missing);
                    livingTarget.invulnerableTime = 0;
                    livingTarget.hurt(player.damageSources().playerAttack(player), extraDamage);
                }
            }
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void mrpgc$onAttackFuseMagicDamage(Entity target, CallbackInfo ci) {
        float magicDamage;
        LivingEntity livingTarget;
        Player player = (Player)this;
        if (target instanceof LivingEntity) {
            AttributeInstance airFuse;
            livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (airFuse = player.getAttribute(MRPGCEntityAttributes.AIR_FUSE_MODIFIER)) != null && airFuse.getValue() != 100.0) {
                float airBonus = (float)((airFuse.getValue() - 100.0) / 100.0);
                float airPower = (float)player.getAttributeValue(MoreSpellSchools.AIR.attributeEntry);
                magicDamage = Math.max(0.1f, airBonus * airPower);
                livingTarget.invulnerableTime = 0;
                livingTarget.hurt(SpellDamageSource.create((SpellSchool)MoreSpellSchools.AIR, (LivingEntity)player), magicDamage);
            }
        }
        if (target instanceof LivingEntity) {
            AttributeInstance arcaneFuse;
            livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (arcaneFuse = player.getAttribute(MRPGCEntityAttributes.ARCANE_FUSE_MODIFIER)) != null && arcaneFuse.getValue() != 100.0) {
                float arcaneBonus = (float)((arcaneFuse.getValue() - 100.0) / 100.0);
                float arcanePower = (float)player.getAttributeValue(SpellSchools.ARCANE.attributeEntry);
                magicDamage = Math.max(0.1f, arcaneBonus * arcanePower);
                livingTarget.invulnerableTime = 0;
                livingTarget.hurt(SpellDamageSource.create((SpellSchool)SpellSchools.ARCANE, (LivingEntity)player), magicDamage);
            }
        }
        if (target instanceof LivingEntity) {
            AttributeInstance earthFuse;
            livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (earthFuse = player.getAttribute(MRPGCEntityAttributes.EARTH_FUSE_MODIFIER)) != null && earthFuse.getValue() != 100.0) {
                float earthBonus = (float)((earthFuse.getValue() - 100.0) / 100.0);
                float earthPower = (float)player.getAttributeValue(MoreSpellSchools.EARTH.attributeEntry);
                magicDamage = Math.max(0.1f, earthBonus * earthPower);
                livingTarget.invulnerableTime = 0;
                livingTarget.hurt(SpellDamageSource.create((SpellSchool)MoreSpellSchools.EARTH, (LivingEntity)player), magicDamage);
            }
        }
        if (target instanceof LivingEntity) {
            AttributeInstance fireFuse;
            livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (fireFuse = player.getAttribute(MRPGCEntityAttributes.FIRE_FUSE_MODIFIER)) != null && fireFuse.getValue() != 100.0) {
                float fireBonus = (float)((fireFuse.getValue() - 100.0) / 100.0);
                float firePower = (float)player.getAttributeValue(SpellSchools.FIRE.attributeEntry);
                magicDamage = Math.max(0.1f, fireBonus * firePower);
                livingTarget.invulnerableTime = 0;
                livingTarget.hurt(SpellDamageSource.create((SpellSchool)SpellSchools.FIRE, (LivingEntity)player), magicDamage);
            }
        }
        if (target instanceof LivingEntity) {
            AttributeInstance frostFuse;
            livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (frostFuse = player.getAttribute(MRPGCEntityAttributes.FROST_FUSE_MODIFIER)) != null && frostFuse.getValue() != 100.0) {
                float frostBonus = (float)((frostFuse.getValue() - 100.0) / 100.0);
                float frostPower = (float)player.getAttributeValue(SpellSchools.FROST.attributeEntry);
                magicDamage = Math.max(0.1f, frostBonus * frostPower);
                livingTarget.invulnerableTime = 0;
                livingTarget.hurt(SpellDamageSource.create((SpellSchool)SpellSchools.FROST, (LivingEntity)player), magicDamage);
            }
        }
        if (target instanceof LivingEntity) {
            AttributeInstance healingFuse;
            livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (healingFuse = player.getAttribute(MRPGCEntityAttributes.HEALING_FUSE_MODIFIER)) != null && healingFuse.getValue() != 100.0) {
                float healingBonus = (float)((healingFuse.getValue() - 100.0) / 100.0);
                float healingPower = (float)player.getAttributeValue(SpellSchools.HEALING.attributeEntry);
                magicDamage = Math.max(0.1f, healingBonus * healingPower);
                livingTarget.invulnerableTime = 0;
                livingTarget.hurt(SpellDamageSource.create((SpellSchool)SpellSchools.HEALING, (LivingEntity)player), magicDamage);
            }
        }
        if (target instanceof LivingEntity) {
            AttributeInstance waterFuse;
            livingTarget = (LivingEntity)target;
            if (!player.level().isClientSide() && (waterFuse = player.getAttribute(MRPGCEntityAttributes.WATER_FUSE_MODIFIER)) != null && waterFuse.getValue() != 100.0) {
                float waterBonus = (float)((waterFuse.getValue() - 100.0) / 100.0);
                float waterPower = (float)player.getAttributeValue(MoreSpellSchools.WATER.attributeEntry);
                magicDamage = Math.max(0.1f, waterBonus * waterPower);
                livingTarget.invulnerableTime = 0;
                livingTarget.hurt(SpellDamageSource.create((SpellSchool)MoreSpellSchools.WATER, (LivingEntity)player), magicDamage);
            }
        }
    }
}

