/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;

public class BindSpellFromPoolsLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "bind_spell_from_pools";
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)"bind_spell_from_pools");
    private final NumberProvider chance;
    public static final MapCodec<BindSpellFromPoolsLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> BindSpellFromPoolsLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.listOf().fieldOf("spell_pools").orElse(List.of()).forGetter(f -> f.pools), (App)NumberProviders.CODEC.fieldOf("count").orElse((Object)ConstantValue.exactly((float)1.0f)).forGetter(f -> f.count), (App)NumberProviders.CODEC.optionalFieldOf("chance").forGetter(f -> Optional.ofNullable(f.chance)))).apply((Applicative)instance, BindSpellFromPoolsLootFunction::new));
    public static final LootItemFunctionType<BindSpellFromPoolsLootFunction> TYPE = new LootItemFunctionType(CODEC);
    private final List<String> pools;
    private final NumberProvider count;

    public BindSpellFromPoolsLootFunction(List<LootItemCondition> conditions, List<String> pools, NumberProvider count, Optional<NumberProvider> chance) {
        super(conditions);
        this.pools = pools;
        this.count = count;
        this.chance = chance.orElse(null);
    }

    public LootItemFunctionType<BindSpellFromPoolsLootFunction> getType() {
        return TYPE;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of();
    }

    private PoolFilters getPools() {
        if (this.pools == null || this.pools.isEmpty()) {
            return new PoolFilters(List.of(), List.of());
        }
        ArrayList<TagKey<Spell>> tags = new ArrayList<TagKey<Spell>>();
        ArrayList<ResourceLocation> exact = new ArrayList<ResourceLocation>();
        for (String entry : this.pools) {
            if (entry.startsWith("#")) {
                ResourceLocation id = ResourceLocation.parse((String)entry.substring(1));
                tags.add((TagKey<Spell>)TagKey.create((ResourceKey)SpellRegistry.KEY, (ResourceLocation)id));
                continue;
            }
            exact.add(ResourceLocation.parse((String)entry));
        }
        return new PoolFilters(tags, exact);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (this.chance != null && context.getRandom().nextFloat() >= this.chance.getFloat(context)) {
            return stack;
        }
        SpellContainer existing = SpellContainerHelper.containerFromItemStack((ItemStack)stack);
        if (existing == null) {
            existing = SpellContainer.EMPTY;
        }
        List<ResourceLocation> alreadyPresentSpells = existing.spell_ids().stream().map(ResourceLocation::parse).toList();
        PoolFilters poolFilters = this.getPools();
        List<Holder.Reference> poolSpells = SpellRegistry.stream((Level)context.getLevel()).filter(entry -> {
            ResourceLocation id;
            block5: {
                block4: {
                    id = ((ResourceKey)entry.unwrapKey().get()).location();
                    if (!poolFilters.tags().isEmpty()) break block4;
                    if (poolFilters.exact().isEmpty()) break block5;
                }
                if (!poolFilters.tags().stream().anyMatch(arg_0 -> ((Holder.Reference)entry).is(arg_0))) {
                    if (!poolFilters.exact().contains(id)) return false;
                }
            }
            boolean bl = true;
            boolean inPool = bl;
            if (!inPool) return false;
            if (alreadyPresentSpells.contains(id)) return false;
            return true;
        }).toList();
        if (poolSpells.isEmpty()) {
            return stack;
        }
        int selectedCount = this.count.getInt(context);
        if (selectedCount < 1) {
            selectedCount = 1;
        }
        RandomSource random = context.getRandom();
        ArrayList<Holder> selected = new ArrayList<Holder>();
        SpellContainer.ContentType contentType = existing.content();
        for (int i = 0; i < selectedCount; ++i) {
            Holder entry2 = (Holder)poolSpells.get(random.nextInt(poolSpells.size()));
            for (int attempts = 3; attempts > 0 && (selected.contains(entry2) || contentType != null && Objects.equals(SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.value())), contentType)); --attempts) {
                entry2 = (Holder)poolSpells.get(random.nextInt(poolSpells.size()));
            }
            selected.add(entry2);
            contentType = SpellContainerHelper.contentTypeForSpell((Spell)((Spell)entry2.value()));
        }
        SpellContainer container = existing.withContentType(contentType != null ? contentType : SpellContainer.ContentType.MAGIC);
        List<String> newSpellIds = selected.stream().map(e -> ((ResourceKey)e.unwrapKey().get()).location().toString()).toList();
        container = container.withAdditionalSpell(newSpellIds);
        List sorted = SpellContainerHelper.sortedSpells((Level)context.getLevel(), (List)container.spell_ids());
        container = container.copyWith(sorted);
        stack.set(SpellDataComponents.SPELL_CONTAINER, (Object)container);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(List<String> pools, NumberProvider count, @Nullable NumberProvider chance) {
        return BindSpellFromPoolsLootFunction.simpleBuilder(conditions -> new BindSpellFromPoolsLootFunction((List<LootItemCondition>)conditions, pools, count, Optional.ofNullable(chance)));
    }

    private record PoolFilters(List<TagKey<Spell>> tags, List<ResourceLocation> exact) {
    }
}

