/*
 * Decompiled with CFR 0.152.
 */
package net.more_rpg_classes.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class ConditionalItemEntry
extends LootPoolSingletonContainer {
    public static final String NAME = "conditional_item";
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"more_rpg_classes", (String)"conditional_item");
    private final ResourceLocation itemId;
    private final Optional<NumberProvider> count;
    public static final MapCodec<ConditionalItemEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.xmap(ResourceLocation::parse, ResourceLocation::toString).fieldOf("item").forGetter(e -> e.itemId), (App)NumberProviders.CODEC.optionalFieldOf("count").forGetter(e -> e.count), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(e -> e.weight), (App)Codec.INT.optionalFieldOf("quality", (Object)0).forGetter(e -> e.quality), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(e -> e.conditions), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(e -> e.functions)).apply((Applicative)instance, ConditionalItemEntry::new));

    public ConditionalItemEntry(ResourceLocation itemId, Optional<NumberProvider> count, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.itemId = itemId;
        this.count = count;
    }

    public LootPoolEntryType getType() {
        return LootPoolEntries.ITEM;
    }

    protected void createItemStack(Consumer<ItemStack> lootConsumer, LootContext context) {
        if (!BuiltInRegistries.ITEM.containsKey(this.itemId)) {
            return;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(this.itemId);
        int c = this.count.map(provider -> provider.getInt(context)).orElse(1);
        if (c < 1) {
            c = 1;
        }
        ItemStack stack = new ItemStack((ItemLike)item, c);
        for (LootItemFunction fn : this.functions) {
            stack = (ItemStack)fn.apply((Object)stack, (Object)context);
        }
        lootConsumer.accept(stack);
    }

    public ResourceLocation getItemId() {
        return this.itemId;
    }

    public Optional<NumberProvider> getCount() {
        return this.count;
    }

    public int getWeightValue() {
        return this.weight;
    }

    public int getQualityValue() {
        return this.quality;
    }

    public List<LootItemCondition> getConditionsList() {
        return this.conditions;
    }

    public List<LootItemFunction> getFunctionsList() {
        return this.functions;
    }
}

